/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestAuthCache;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRequestAuthCache {
    private HttpHost target;
    private HttpHost proxy;
    private Credentials creds1;
    private Credentials creds2;
    private AuthScope authscope1;
    private AuthScope authscope2;
    private BasicScheme authscheme1;
    private BasicScheme authscheme2;
    private BasicCredentialsProvider credProvider;

    @Before
    public void setUp() {
        this.target = new HttpHost("localhost", 80);
        this.proxy = new HttpHost("localhost", 8080);
        this.credProvider = new BasicCredentialsProvider();
        this.creds1 = new UsernamePasswordCredentials("user1", "secret1".toCharArray());
        this.creds2 = new UsernamePasswordCredentials("user2", "secret2".toCharArray());
        this.authscope1 = new AuthScope(this.target);
        this.authscope2 = new AuthScope(this.proxy);
        this.authscheme1 = new BasicScheme();
        this.authscheme2 = new BasicScheme();
        this.credProvider.setCredentials(this.authscope1, this.creds1);
        this.credProvider.setCredentials(this.authscope2, this.creds2);
    }

    @Test(expected=NullPointerException.class)
    public void testRequestParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process(null, null, (HttpContext)context);
    }

    @Test(expected=NullPointerException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, null, null);
    }

    @Test
    public void testPreemptiveTargetAndProxyAuth() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        AuthExchange targetAuthExchange = context.getAuthExchange(this.target);
        AuthExchange proxyAuthExchange = context.getAuthExchange(this.proxy);
        Assert.assertNotNull((Object)targetAuthExchange);
        Assert.assertNotNull((Object)targetAuthExchange.getAuthScheme());
        Assert.assertNotNull((Object)proxyAuthExchange);
        Assert.assertNotNull((Object)proxyAuthExchange.getAuthScheme());
    }

    @Test
    public void testCredentialsProviderNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", null);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        AuthExchange targetAuthExchange = context.getAuthExchange(this.target);
        AuthExchange proxyAuthExchange = context.getAuthExchange(this.proxy);
        Assert.assertNotNull((Object)targetAuthExchange);
        Assert.assertNull((Object)targetAuthExchange.getAuthScheme());
        Assert.assertNotNull((Object)proxyAuthExchange);
        Assert.assertNull((Object)proxyAuthExchange.getAuthScheme());
    }

    @Test
    public void testAuthCacheNotSet() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        context.setAttribute("http.auth.auth-cache", null);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        AuthExchange targetAuthExchange = context.getAuthExchange(this.target);
        AuthExchange proxyAuthExchange = context.getAuthExchange(this.proxy);
        Assert.assertNotNull((Object)targetAuthExchange);
        Assert.assertNull((Object)targetAuthExchange.getAuthScheme());
        Assert.assertNotNull((Object)proxyAuthExchange);
        Assert.assertNull((Object)proxyAuthExchange.getAuthScheme());
    }

    @Test
    public void testAuthCacheEmpty() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        context.setAttribute("http.auth.credentials-provider", (Object)this.credProvider);
        context.setAttribute("http.route", (Object)new HttpRoute(this.target, null, this.proxy, false));
        BasicAuthCache authCache = new BasicAuthCache();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        RequestAuthCache interceptor = new RequestAuthCache();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        AuthExchange targetAuthExchange = context.getAuthExchange(this.target);
        AuthExchange proxyAuthExchange = context.getAuthExchange(this.proxy);
        Assert.assertNotNull((Object)targetAuthExchange);
        Assert.assertNull((Object)targetAuthExchange.getAuthScheme());
        Assert.assertNotNull((Object)proxyAuthExchange);
        Assert.assertNull((Object)proxyAuthExchange.getAuthScheme());
    }
}

