/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.impl.classic.AbstractHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAbstractHttpClientResponseHandler {
    @Test
    public void testSuccessfulResponse() throws Exception {
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        StringEntity entity = new StringEntity("42");
        Mockito.when((Object)response.getCode()).thenReturn((Object)200);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        AbstractHttpClientResponseHandler<Integer> handler = new AbstractHttpClientResponseHandler<Integer>(){

            public Integer handleEntity(HttpEntity entity) throws IOException {
                return Integer.valueOf(new String(EntityUtils.toByteArray((HttpEntity)entity)));
            }
        };
        Integer number = (Integer)handler.handleResponse(response);
        Assert.assertEquals((long)42L, (long)number.intValue());
    }

    @Test
    public void testUnsuccessfulResponse() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)response.getCode()).thenReturn((Object)404);
        Mockito.when((Object)response.getReasonPhrase()).thenReturn((Object)"NOT FOUND");
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
        try {
            handler.handleResponse(response);
            Assert.fail((String)"HttpResponseException expected");
        }
        catch (HttpResponseException ex) {
            Assert.assertEquals((long)404L, (long)ex.getStatusCode());
            Assert.assertEquals((Object)"NOT FOUND", (Object)ex.getReasonPhrase());
            Assert.assertEquals((Object)"status code: 404, reason phrase: NOT FOUND", (Object)ex.getMessage());
        }
        ((HttpEntity)Mockito.verify((Object)entity)).getContent();
        ((InputStream)Mockito.verify((Object)inStream)).close();
    }

    @Test
    public void testUnsuccessfulResponseEmptyReason() throws Exception {
        InputStream inStream = (InputStream)Mockito.mock(InputStream.class);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)entity.getContent()).thenReturn((Object)inStream);
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)response.getCode()).thenReturn((Object)404);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)entity);
        BasicHttpClientResponseHandler handler = new BasicHttpClientResponseHandler();
        try {
            handler.handleResponse(response);
            Assert.fail((String)"HttpResponseException expected");
        }
        catch (HttpResponseException ex) {
            Assert.assertEquals((long)404L, (long)ex.getStatusCode());
            Assert.assertNull((Object)ex.getReasonPhrase());
            Assert.assertEquals((Object)"status code: 404", (Object)ex.getMessage());
        }
        ((HttpEntity)Mockito.verify((Object)entity)).getContent();
        ((InputStream)Mockito.verify((Object)inStream)).close();
    }
}

