/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.InternalExecRuntime;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.impl.io.HttpRequestExecutor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class TestInternalExecRuntime {
    @Mock
    private Logger log;
    @Mock
    private HttpClientConnectionManager mgr;
    @Mock
    private LeaseRequest leaseRequest;
    @Mock
    private HttpRequestExecutor requestExecutor;
    @Mock
    private CancellableDependency cancellableDependency;
    @Mock
    private ConnectionEndpoint connectionEndpoint;
    private HttpRoute route;
    private InternalExecRuntime execRuntime;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.route = new HttpRoute(new HttpHost("host", 80));
        this.execRuntime = new InternalExecRuntime(this.log, this.mgr, this.requestExecutor, this.cancellableDependency);
    }

    @Test
    public void testAcquireEndpoint() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(345L, TimeUnit.MILLISECONDS).setConnectTimeout(123L, TimeUnit.MILLISECONDS).build();
        context.setRequestConfig(config);
        HttpRoute route = new HttpRoute(new HttpHost("host", 80));
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        Assert.assertSame((Object)this.connectionEndpoint, (Object)this.execRuntime.ensureValid());
        Assert.assertFalse((boolean)this.execRuntime.isEndpointConnected());
        Assert.assertFalse((boolean)this.execRuntime.isConnectionReusable());
        ((LeaseRequest)Mockito.verify((Object)this.leaseRequest)).get(Timeout.ofMilliseconds((long)345L));
        ((CancellableDependency)Mockito.verify((Object)this.cancellableDependency, (VerificationMode)Mockito.times((int)1))).setDependency((Cancellable)this.leaseRequest);
        ((CancellableDependency)Mockito.verify((Object)this.cancellableDependency, (VerificationMode)Mockito.times((int)1))).setDependency((Cancellable)this.execRuntime);
        ((CancellableDependency)Mockito.verify((Object)this.cancellableDependency, (VerificationMode)Mockito.times((int)2))).setDependency((Cancellable)Mockito.any());
    }

    @Test(expected=IllegalStateException.class)
    public void testAcquireEndpointAlreadyAcquired() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        Assert.assertSame((Object)this.connectionEndpoint, (Object)this.execRuntime.ensureValid());
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
    }

    @Test(expected=ConnectionRequestTimeoutException.class)
    public void testAcquireEndpointLeaseRequestTimeout() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenThrow(new Throwable[]{new TimeoutException("timeout")});
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
    }

    @Test(expected=RequestFailedException.class)
    public void testAcquireEndpointLeaseRequestFailure() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenThrow(new Throwable[]{new ExecutionException(new IllegalStateException())});
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
    }

    @Test
    public void testAbortEndpoint() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", new HttpRoute(new HttpHost("host", 80)), null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        this.execRuntime.discardEndpoint();
        Assert.assertFalse((boolean)this.execRuntime.isEndpointAcquired());
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint)).close(CloseMode.IMMEDIATE);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).release(this.connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
        this.execRuntime.discardEndpoint();
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint, (VerificationMode)Mockito.times((int)1))).close(CloseMode.IMMEDIATE);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).release((ConnectionEndpoint)Mockito.any(), Mockito.any(), (TimeValue)Mockito.any());
    }

    @Test
    public void testCancell() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        Assert.assertTrue((boolean)this.execRuntime.cancel());
        Assert.assertFalse((boolean)this.execRuntime.isEndpointAcquired());
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint)).close(CloseMode.IMMEDIATE);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).release(this.connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
        Assert.assertFalse((boolean)this.execRuntime.cancel());
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint, (VerificationMode)Mockito.times((int)1))).close(CloseMode.IMMEDIATE);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).release((ConnectionEndpoint)Mockito.any(), Mockito.any(), (TimeValue)Mockito.any());
    }

    @Test
    public void testReleaseEndpointReusable() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        this.execRuntime.markConnectionReusable((Object)"some state", TimeValue.ofMilliseconds((long)100000L));
        this.execRuntime.releaseEndpoint();
        Assert.assertFalse((boolean)this.execRuntime.isEndpointAcquired());
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint, (VerificationMode)Mockito.never())).close();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).release(this.connectionEndpoint, (Object)"some state", TimeValue.ofMilliseconds((long)100000L));
        this.execRuntime.releaseEndpoint();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).release((ConnectionEndpoint)Mockito.any(), Mockito.any(), (TimeValue)Mockito.any());
    }

    @Test
    public void testReleaseEndpointNonReusable() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        this.execRuntime.markConnectionReusable((Object)"some state", TimeValue.ofMilliseconds((long)100000L));
        this.execRuntime.markConnectionNonReusable();
        this.execRuntime.releaseEndpoint();
        Assert.assertFalse((boolean)this.execRuntime.isEndpointAcquired());
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint, (VerificationMode)Mockito.times((int)1))).close(CloseMode.IMMEDIATE);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).release(this.connectionEndpoint, null, TimeValue.ZERO_MILLISECONDS);
        this.execRuntime.releaseEndpoint();
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.times((int)1))).release((ConnectionEndpoint)Mockito.any(), Mockito.any(), (TimeValue)Mockito.any());
    }

    @Test
    public void testConnectEndpoint() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(345L, TimeUnit.MILLISECONDS).setConnectTimeout(123L, TimeUnit.MILLISECONDS).build();
        context.setRequestConfig(config);
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        Mockito.when((Object)this.connectionEndpoint.isConnected()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.execRuntime.isEndpointConnected());
        this.execRuntime.connectEndpoint(context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr)).connect(this.connectionEndpoint, (TimeValue)Timeout.ofMilliseconds((long)123L), (HttpContext)context);
    }

    @Test
    public void testDisonnectEndpoint() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.mgr.lease((String)Mockito.eq((Object)"some-id"), (HttpRoute)Mockito.eq((Object)this.route), (Timeout)Mockito.any(), Mockito.any())).thenReturn((Object)this.leaseRequest);
        Mockito.when((Object)this.leaseRequest.get((Timeout)Mockito.any())).thenReturn((Object)this.connectionEndpoint);
        this.execRuntime.acquireEndpoint("some-id", this.route, null, context);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointAcquired());
        Mockito.when((Object)this.connectionEndpoint.isConnected()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.execRuntime.isEndpointConnected());
        this.execRuntime.connectEndpoint(context);
        ((HttpClientConnectionManager)Mockito.verify((Object)this.mgr, (VerificationMode)Mockito.never())).connect((ConnectionEndpoint)Mockito.same((Object)this.connectionEndpoint), (TimeValue)Mockito.any(), (HttpContext)Mockito.any());
        this.execRuntime.disconnectEndpoint();
        ((ConnectionEndpoint)Mockito.verify((Object)this.connectionEndpoint)).close();
    }
}

