/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthExchange;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.NTLMScheme;
import org.apache.hc.client5.http.impl.classic.ProtocolExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestProtocolExec {
    @Mock
    private HttpProcessor httpProcessor;
    @Mock
    private AuthenticationStrategy targetAuthStrategy;
    @Mock
    private AuthenticationStrategy proxyAuthStrategy;
    @Mock
    private ExecChain chain;
    @Mock
    private ExecRuntime execRuntime;
    private ProtocolExec protocolExec;
    private HttpHost target;
    private HttpHost proxy;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.protocolExec = new ProtocolExec(this.httpProcessor, this.targetAuthStrategy, this.proxyAuthStrategy);
        this.target = new HttpHost("foo", 80);
        this.proxy = new HttpHost("bar", 8888);
    }

    @Test
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((HttpProcessor)Mockito.verify((Object)this.httpProcessor)).process((HttpRequest)request, null, (HttpContext)context);
        ((ExecChain)Mockito.verify((Object)this.chain)).proceed((ClassicHttpRequest)request, scope);
        ((HttpProcessor)Mockito.verify((Object)this.httpProcessor)).process((HttpResponse)response, null, (HttpContext)context);
        Assert.assertEquals((Object)route, (Object)context.getHttpRoute());
        Assert.assertSame((Object)request, (Object)context.getRequest());
        Assert.assertSame((Object)response, (Object)context.getResponse());
    }

    @Test
    public void testUserInfoInRequestURI() throws Exception {
        HttpRoute route = new HttpRoute(new HttpHost("somehost", 8080));
        HttpGet request = new HttpGet("http://somefella:secret@bar/test");
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        Assert.assertEquals((Object)new URI("http://bar/test"), (Object)request.getUri());
        CredentialsProvider credentialsProvider = context.getCredentialsProvider();
        Credentials creds = credentialsProvider.getCredentials(new AuthScope(null, "bar", -1, null, null), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"somefella", (Object)creds.getUserPrincipal().getName());
    }

    @Test(expected=HttpException.class)
    public void testPostProcessHttpException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((HttpProcessor)Mockito.doThrow((Throwable[])new Throwable[]{new HttpException("Ooopsie")}).when((Object)this.httpProcessor)).process((HttpResponse)Mockito.same((Object)response), (EntityDetails)Mockito.isNull(), (HttpContext)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        try {
            this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
            throw ex;
        }
    }

    @Test(expected=IOException.class)
    public void testPostProcessIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((HttpProcessor)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Ooopsie")}).when((Object)this.httpProcessor)).process((HttpResponse)Mockito.same((Object)response), (EntityDetails)Mockito.isNull(), (HttpContext)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        try {
            this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
            throw ex;
        }
    }

    @Test(expected=RuntimeException.class)
    public void testPostProcessRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((HttpProcessor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Ooopsie")}).when((Object)this.httpProcessor)).process((HttpResponse)Mockito.same((Object)response), (EntityDetails)Mockito.isNull(), (HttpContext)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        try {
            this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        }
        catch (Exception ex) {
            ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
            throw ex;
        }
    }

    @Test
    public void testExecRequestRetryOnAuthChallenge() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpGet request = new HttpGet("http://foo/test");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(401, "Huh?");
        response1.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(inStream1).build());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        InputStream inStream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{2, 3, 4}));
        response2.setEntity(EntityBuilder.create().setStream(inStream2).build());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.target), (Credentials)new UsernamePasswordCredentials("user", "pass".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response1, (Object[])new ClassicHttpResponse[]{response2});
        Mockito.when((Object)this.targetAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.TARGET), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)request, scope);
        ((InputStream)Mockito.verify((Object)inStream1)).close();
        ((InputStream)Mockito.verify((Object)inStream2, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertEquals((long)200L, (long)finalResponse.getCode());
    }

    @Test
    public void testExecEntityEnclosingRequestRetryOnAuthChallenge() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("http://foo/test");
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(401, "Huh?");
        response1.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        response1.setEntity(EntityBuilder.create().setStream(inStream1).build());
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        InputStream inStream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{2, 3, 4}));
        response2.setEntity(EntityBuilder.create().setStream(inStream2).build());
        HttpClientContext context = new HttpClientContext();
        AuthExchange authExchange = new AuthExchange();
        authExchange.setState(AuthExchange.State.SUCCESS);
        authExchange.select((AuthScheme)new NTLMScheme());
        context.setAuthExchange(this.target, authExchange);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.target), (Credentials)new UsernamePasswordCredentials("user", "pass".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response1, (Object[])new ClassicHttpResponse[]{response2});
        Mockito.when((Object)this.targetAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.TARGET), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse finalResponse = this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)request, scope);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).disconnectEndpoint();
        ((InputStream)Mockito.verify((Object)inStream2, (VerificationMode)Mockito.never())).close();
        Assert.assertNotNull((Object)finalResponse);
        Assert.assertEquals((long)200L, (long)finalResponse.getCode());
        Assert.assertNotNull((Object)authExchange.getAuthScheme());
    }

    @Test
    public void testExecEntityEnclosingRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpClientContext context = new HttpClientContext();
        HttpPost request = new HttpPost("http://foo/test");
        ByteArrayInputStream inStream0 = new ByteArrayInputStream(new byte[]{1, 2, 3});
        request.setEntity(EntityBuilder.create().setStream((InputStream)inStream0).build());
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(401, "Huh?");
        response1.setHeader("WWW-Authenticate", (Object)"Basic realm=test");
        ByteArrayInputStream inStream1 = new ByteArrayInputStream(new byte[]{1, 2, 3});
        response1.setEntity(EntityBuilder.create().setStream((InputStream)inStream1).build());
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(this.target), (Credentials)new UsernamePasswordCredentials("user", "pass".toCharArray()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenAnswer((Answer)new Answer<HttpResponse>((ClassicHttpResponse)response1){
            final /* synthetic */ ClassicHttpResponse val$response1;
            {
                this.val$response1 = classicHttpResponse;
            }

            public HttpResponse answer(InvocationOnMock invocationOnMock) throws Throwable {
                Object[] args = invocationOnMock.getArguments();
                ClassicHttpRequest requestEE = (ClassicHttpRequest)args[0];
                requestEE.getEntity().writeTo((OutputStream)new ByteArrayOutputStream());
                return this.val$response1;
            }
        });
        Mockito.when((Object)this.targetAuthStrategy.select((ChallengeType)Mockito.eq((Object)ChallengeType.TARGET), (Map)Mockito.any(), (HttpContext)Mockito.any())).thenReturn(Collections.singletonList(new BasicScheme()));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.execRuntime, context);
        ClassicHttpResponse response = this.protocolExec.execute((ClassicHttpRequest)request, scope, this.chain);
        Assert.assertEquals((long)401L, (long)response.getCode());
    }
}

