/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicClientCookie {
    @Test
    public void testConstructor() {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
        try {
            new BasicClientCookie(null, null);
            Assert.fail((String)"NullPointerException should have been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testCloning() throws Exception {
        BasicClientCookie orig = new BasicClientCookie("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        BasicClientCookie clone = (BasicClientCookie)orig.clone();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
    }

    @Test
    public void testSerialization() throws Exception {
        BasicClientCookie orig = new BasicClientCookie("name", "value");
        orig.setDomain("domain");
        orig.setPath("/");
        orig.setAttribute("attrib", "stuff");
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);
        outStream.writeObject(orig);
        outStream.close();
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        BasicClientCookie clone = (BasicClientCookie)inStream.readObject();
        Assert.assertEquals((Object)orig.getName(), (Object)clone.getName());
        Assert.assertEquals((Object)orig.getValue(), (Object)clone.getValue());
        Assert.assertEquals((Object)orig.getDomain(), (Object)clone.getDomain());
        Assert.assertEquals((Object)orig.getPath(), (Object)clone.getPath());
        Assert.assertEquals((Object)orig.getAttribute("attrib"), (Object)clone.getAttribute("attrib"));
    }
}

