/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.pool.StrictConnPool;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestPoolingHttpClientConnectionManager {
    @Mock
    private ManagedHttpClientConnection conn;
    @Mock
    private Lookup<ConnectionSocketFactory> socketFactoryRegistry;
    @Mock
    private ConnectionSocketFactory plainSocketFactory;
    @Mock
    private ConnectionSocketFactory sslSocketFactory;
    @Mock
    private Socket socket;
    @Mock
    private SchemePortResolver schemePortResolver;
    @Mock
    private DnsResolver dnsResolver;
    @Mock
    private Future<PoolEntry<HttpRoute, ManagedHttpClientConnection>> future;
    @Mock
    private StrictConnPool<HttpRoute, ManagedHttpClientConnection> pool;
    private PoolingHttpClientConnectionManager mgr;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.mgr = new PoolingHttpClientConnectionManager((HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator(this.socketFactoryRegistry, this.schemePortResolver, this.dnsResolver), this.pool, null);
    }

    @Test
    public void testLeaseRelease() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assert.assertNotNull((Object)endpoint1);
        Assert.assertNotSame((Object)this.conn, (Object)endpoint1);
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, true);
    }

    @Test
    public void testReleaseRouteIncomplete() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)80);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assert.assertNotNull((Object)endpoint1);
        Assert.assertNotSame((Object)this.conn, (Object)endpoint1);
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, false);
    }

    @Test(expected=TimeoutException.class)
    public void testLeaseFutureTimeout() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.TRUE);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenThrow(new Throwable[]{new TimeoutException()});
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        connRequest1.get(Timeout.ofSeconds((long)1L));
    }

    @Test
    public void testReleaseReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)true);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assert.assertNotNull((Object)endpoint1);
        Assert.assertTrue((boolean)endpoint1.isConnected());
        this.mgr.release(endpoint1, (Object)"some state", TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, true);
        Assert.assertEquals((Object)"some state", (Object)entry.getState());
    }

    @Test
    public void testReleaseNonReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.FALSE);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assert.assertNotNull((Object)endpoint1);
        Assert.assertFalse((boolean)endpoint1.isConnected());
        this.mgr.release(endpoint1, (Object)"some state", TimeValue.NEG_ONE_MILLISECOND);
        ((StrictConnPool)Mockito.verify(this.pool)).release(entry, false);
        Assert.assertEquals(null, (Object)entry.getState());
    }

    @Test
    public void testTargetConnect() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, true);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)false);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assert.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setDefaultSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)this.plainSocketFactory);
        Mockito.when((Object)this.plainSocketFactory.createSocket((HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.plainSocketFactory.connectSocket((TimeValue)Mockito.any(), (Socket)Mockito.eq((Object)this.socket), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(endpoint1, TimeValue.ofMilliseconds((long)123L), (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("somehost");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)this.plainSocketFactory, (VerificationMode)Mockito.times((int)1))).connectSocket(TimeValue.ofMilliseconds((long)123L), this.socket, target, new InetSocketAddress(remote, 8443), new InetSocketAddress(local, 0), (HttpContext)context);
    }

    @Test
    public void testProxyConnectAndUpgrade() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        HttpHost proxy = new HttpHost("someproxy", 8080);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, proxy, true);
        PoolEntry entry = new PoolEntry((Object)route, TimeValue.NEG_ONE_MILLISECOND);
        entry.assignConnection((ModalCloseable)this.conn);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)false);
        Mockito.when((Object)this.future.isCancelled()).thenReturn((Object)false);
        Mockito.when(this.future.get(1L, TimeUnit.SECONDS)).thenReturn((Object)entry);
        Mockito.when((Object)this.pool.lease(Mockito.eq((Object)route), Mockito.eq(null), (Timeout)Mockito.any(), (FutureCallback)Mockito.eq(null))).thenReturn(this.future);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ofSeconds((long)1L));
        Assert.assertNotNull((Object)endpoint1);
        ConnectionSocketFactory plainsf = (ConnectionSocketFactory)Mockito.mock(ConnectionSocketFactory.class);
        LayeredConnectionSocketFactory sslsf = (LayeredConnectionSocketFactory)Mockito.mock(LayeredConnectionSocketFactory.class);
        Socket mockSock = (Socket)Mockito.mock(Socket.class);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setDefaultSocketConfig(sconfig);
        Mockito.when((Object)this.dnsResolver.resolve("someproxy")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(proxy)).thenReturn((Object)8080);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)8443);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("http")).thenReturn((Object)plainsf);
        Mockito.when((Object)this.socketFactoryRegistry.lookup("https")).thenReturn((Object)sslsf);
        Mockito.when((Object)plainsf.createSocket((HttpContext)Mockito.any())).thenReturn((Object)mockSock);
        Mockito.when((Object)plainsf.connectSocket((TimeValue)Mockito.any(), (Socket)Mockito.eq((Object)mockSock), (HttpHost)Mockito.any(), (InetSocketAddress)Mockito.any(), (InetSocketAddress)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)mockSock);
        this.mgr.connect(endpoint1, TimeValue.ofMilliseconds((long)123L), (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("someproxy");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(proxy);
        ((ConnectionSocketFactory)Mockito.verify((Object)plainsf, (VerificationMode)Mockito.times((int)1))).createSocket((HttpContext)context);
        ((ConnectionSocketFactory)Mockito.verify((Object)plainsf, (VerificationMode)Mockito.times((int)1))).connectSocket(TimeValue.ofMilliseconds((long)123L), mockSock, proxy, new InetSocketAddress(remote, 8080), new InetSocketAddress(local, 0), (HttpContext)context);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)mockSock);
        this.mgr.upgrade(endpoint1, (HttpContext)context);
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target);
        ((LayeredConnectionSocketFactory)Mockito.verify((Object)sslsf, (VerificationMode)Mockito.times((int)1))).createLayeredSocket(mockSock, "somehost", 8443, (HttpContext)context);
    }
}

