/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.URI;
import org.apache.hc.client5.http.routing.RoutingSupport;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.net.URIAuthority;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestRoutingSupport {
    @Test
    public void testDetermineHost() throws Exception {
        BasicHttpRequest request1 = new BasicHttpRequest("GET", "/");
        HttpHost host1 = RoutingSupport.determineHost((HttpRequest)request1);
        Assert.assertThat((Object)host1, (Matcher)CoreMatchers.nullValue());
        BasicHttpRequest request2 = new BasicHttpRequest("GET", new URI("https://somehost:8443/"));
        HttpHost host2 = RoutingSupport.determineHost((HttpRequest)request2);
        Assert.assertThat((Object)host2, (Matcher)CoreMatchers.equalTo((Object)new HttpHost("https", "somehost", 8443)));
    }

    @Test(expected=ProtocolException.class)
    public void testDetermineHostMissingScheme() throws Exception {
        BasicHttpRequest request1 = new BasicHttpRequest("GET", "/");
        request1.setAuthority(new URIAuthority("host"));
        RoutingSupport.determineHost((HttpRequest)request1);
    }
}

