/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSystemDefaultRoutePlanner {
    private SchemePortResolver schemePortResolver;
    private ProxySelector proxySelector;
    private SystemDefaultRoutePlanner routePlanner;

    @Before
    public void setup() {
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.proxySelector = (ProxySelector)Mockito.mock(ProxySelector.class);
        this.routePlanner = new SystemDefaultRoutePlanner(this.schemePortResolver, this.proxySelector);
    }

    @Test
    public void testDirect() throws Exception {
        HttpHost target = new HttpHost("http", "somehost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((long)1L, (long)route.getHopCount());
        Assert.assertFalse((boolean)route.isSecure());
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.never())).resolve((HttpHost)ArgumentMatchers.any());
    }

    @Test
    public void testDirectDefaultPort() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", -1);
        Mockito.when((Object)this.schemePortResolver.resolve(target)).thenReturn((Object)443);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assert.assertEquals((Object)new HttpHost("https", "somehost", 443), (Object)route.getTargetHost());
        Assert.assertEquals((long)1L, (long)route.getHopCount());
        Assert.assertTrue((boolean)route.isSecure());
    }

    @Test
    public void testProxy() throws Exception {
        InetAddress ia = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetSocketAddress isa1 = new InetSocketAddress(ia, 11111);
        InetSocketAddress isa2 = new InetSocketAddress(ia, 22222);
        ArrayList<Proxy> proxies = new ArrayList<Proxy>(2);
        proxies.add(new Proxy(Proxy.Type.HTTP, isa1));
        proxies.add(new Proxy(Proxy.Type.HTTP, isa2));
        Mockito.when(this.proxySelector.select(new URI("http://somehost:80"))).thenReturn(proxies);
        HttpHost target = new HttpHost("http", "somehost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HttpRoute route = this.routePlanner.determineRoute(target, (HttpContext)context);
        Assert.assertEquals((Object)target, (Object)route.getTargetHost());
        Assert.assertEquals((long)2L, (long)route.getHopCount());
        Assert.assertEquals((long)isa1.getPort(), (long)route.getProxyHost().getPort());
    }
}

