/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestClientConnControl;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestClientConnControl {
    @Test(expected=NullPointerException.class)
    public void testRequestParameterCheck() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process(null, null, (HttpContext)context);
    }

    @Test
    public void testConnectionKeepAliveForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        HttpClientContext context = HttpClientContext.create();
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testConnectionKeepAliveForDirectRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("http", "localhost", 80);
        HttpRoute route = new HttpRoute(target, null, false);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"keep-alive", (Object)header.getValue());
    }

    @Test
    public void testConnectionKeepAliveForTunneledRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("https", "localhost", 443);
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"keep-alive", (Object)header.getValue());
    }

    @Test
    public void testProxyConnectionKeepAliveForRequestsOverProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("http", "localhost", 80);
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testPreserveCustomConnectionHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Connection", (Object)"close");
        HttpClientContext context = HttpClientContext.create();
        HttpHost target = new HttpHost("https", "localhost", 443);
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        context.setAttribute("http.route", (Object)route);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"close", (Object)header.getValue());
    }
}

