/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.util.ArrayList;
import org.apache.hc.client5.http.protocol.RequestDefaultHeaders;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestDefaultHeaders {
    @Test(expected=NullPointerException.class)
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders();
        interceptor.process(null, null, (HttpContext)context);
    }

    @Test
    public void testNoDefaultHeadersForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", (Object)"stuff"));
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders(defheaders);
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header1 = request.getFirstHeader("custom");
        Assert.assertNull((Object)header1);
    }

    @Test
    public void testDefaultHeaders() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("custom", (Object)"stuff");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", (Object)"other stuff"));
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders(defheaders);
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header[] headers = request.getHeaders("custom");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)"stuff", (Object)headers[0].getValue());
    }
}

