/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestExpectContinue {
    @Test
    public void testRequestExpectContinueGenerated() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)"100-continue", (Object)header.getValue());
    }

    @Test
    public void testRequestExpectContinueNotGenerated() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(false).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("100-continue");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueHTTP10() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        String s = "whatever";
        StringEntity entity = new StringEntity("whatever", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("100-continue");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueZeroContent() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        RequestConfig config = RequestConfig.custom().setExpectContinueEnabled(true).build();
        context.setAttribute("http.request-config", (Object)config);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        String s = "";
        StringEntity entity = new StringEntity("", StandardCharsets.US_ASCII);
        request.setEntity((HttpEntity)entity);
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Header header = request.getFirstHeader("100-continue");
        Assert.assertNull((Object)header);
    }

    @Test
    public void testRequestExpectContinueInvalidInput() throws Exception {
        RequestExpectContinue interceptor = new RequestExpectContinue();
        try {
            interceptor.process(null, null, null);
            Assert.fail((String)"NullPointerException should have been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRequestExpectContinueIgnoreNonenclosingRequests() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", "/");
        RequestExpectContinue interceptor = new RequestExpectContinue();
        interceptor.process((HttpRequest)request, null, (HttpContext)context);
        Assert.assertEquals((long)0L, (long)request.getHeaders().length);
    }
}

