/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.utils.ByteArrayBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestByteArrayBuilder {
    @Test
    public void testEmptyBuffer() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        ByteBuffer byteBuffer = buffer.toByteBuffer();
        Assert.assertNotNull((Object)byteBuffer);
        Assert.assertEquals((long)0L, (long)byteBuffer.capacity());
        byte[] bytes = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((long)0L, (long)bytes.length);
    }

    @Test
    public void testAppendBytes() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append(new byte[]{1, 2, 3, 4, 5});
        buffer.append(new byte[]{3, 4, 5, 6, 7, 8, 9, 10, 11}, 3, 5);
        buffer.append((byte[])null);
        byte[] bytes = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (byte[])bytes);
    }

    @Test
    public void testInvalidAppendBytes() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append((byte[])null, 0, 0);
        byte[] tmp = new byte[]{1, 2, 3, 4};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEnsureCapacity() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.ensureFreeCapacity(10);
        Assert.assertEquals((long)10L, (long)buffer.capacity());
        buffer.ensureFreeCapacity(5);
        Assert.assertEquals((long)10L, (long)buffer.capacity());
        buffer.append(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        buffer.ensureFreeCapacity(5);
        Assert.assertEquals((long)13L, (long)buffer.capacity());
        buffer.ensureFreeCapacity(15);
        Assert.assertEquals((long)23L, (long)buffer.capacity());
    }

    @Test
    public void testAppendText() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append(new char[]{'1', '2', '3', '4', '5'});
        buffer.append(new char[]{'3', '4', '5', '6', '7', '8', '9', 'a', 'b'}, 3, 5);
        buffer.append("bcd");
        buffer.append("e");
        buffer.append("f");
        buffer.append("");
        buffer.append((String)null);
        buffer.append((char[])null);
        byte[] bytes = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes);
        Assert.assertEquals((Object)"123456789abcdef", (Object)new String(bytes, StandardCharsets.US_ASCII));
    }

    @Test
    public void testInvalidAppendChars() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append((char[])null, 0, 0);
        char[] tmp = new char[]{'\u0001', '\u0002', '\u0003', '\u0004'};
        try {
            buffer.append(tmp, -1, 0);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 0, 8);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 10, Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            buffer.append(tmp, 2, 4);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testReset() throws Exception {
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append("abcd");
        buffer.append("e");
        buffer.append("f");
        byte[] bytes1 = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes1);
        Assert.assertEquals((Object)"abcdef", (Object)new String(bytes1, StandardCharsets.US_ASCII));
        buffer.reset();
        byte[] bytes2 = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((Object)"", (Object)new String(bytes2, StandardCharsets.US_ASCII));
    }

    @Test
    public void testNonAsciiCharset() throws Exception {
        int[] germanChars = new int[]{228, 45, 246, 45, 252};
        StringBuilder tmp = new StringBuilder();
        for (int germanChar : germanChars) {
            tmp.append((char)germanChar);
        }
        String umlauts = tmp.toString();
        ByteArrayBuilder buffer = new ByteArrayBuilder();
        buffer.append(umlauts);
        byte[] bytes1 = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes1);
        Assert.assertEquals((Object)"?-?-?", (Object)new String(bytes1, StandardCharsets.US_ASCII));
        buffer.reset();
        buffer.charset(StandardCharsets.UTF_8);
        buffer.append(umlauts);
        byte[] bytes2 = buffer.toByteArray();
        Assert.assertNotNull((Object)bytes2);
        Assert.assertEquals((Object)umlauts, (Object)new String(bytes2, StandardCharsets.UTF_8));
    }
}

