/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.util.Calendar;
import java.util.Date;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtils {
    private static Date createDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(DateUtils.GMT);
        calendar.setTimeInMillis(0L);
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    @Test
    public void testBasicDateParse() throws Exception {
        Date date = TestDateUtils.createDate(2005, 9, 14);
        String[] formats = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"};
        Assert.assertEquals((Object)date, (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (String[])formats, null));
        Assert.assertEquals((Object)date, (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (String[])formats));
        Assert.assertEquals((Object)date, (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT"));
    }

    @Test
    public void testDateParseMessage() throws Exception {
        HeaderGroup message1 = new HeaderGroup();
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Fri, 14 Oct 2005 00:00:00 GMT"));
        Assert.assertEquals((Object)TestDateUtils.createDate(2005, 9, 14), (Object)DateUtils.parseDate((MessageHeaders)message1, (String)"Date"));
        HeaderGroup message2 = new HeaderGroup();
        message2.addHeader((Header)new BasicHeader("Date", (Object)"Fri, 14 Oct 2005 00:00:00 GMT"));
        message2.addHeader((Header)new BasicHeader("Date", (Object)"Fri, 21 Oct 2005 00:00:00 GMT"));
        Assert.assertEquals((Object)TestDateUtils.createDate(2005, 9, 14), (Object)DateUtils.parseDate((MessageHeaders)message2, (String)"Date"));
    }

    @Test
    public void testMalformedDate() {
        Assert.assertNull((Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (String[])new String[0], null));
    }

    @Test
    public void testInvalidInput() throws Exception {
        try {
            DateUtils.parseDate(null, null, null);
            Assert.fail((String)"NullPointerException should habe been thrown");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            DateUtils.formatDate(null);
            Assert.fail((String)"NullPointerException should habe been thrown");
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            DateUtils.formatDate((Date)new Date(), null);
            Assert.fail((String)"NullPointerException should habe been thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testTwoDigitYearDateParse() throws Exception {
        String[] formats = new String[]{"EEE, dd-MMM-yy HH:mm:ss zzz"};
        Assert.assertEquals((Object)TestDateUtils.createDate(2005, 9, 14), (Object)DateUtils.parseDate((String)"Friday, 14-Oct-05 00:00:00 GMT", (String[])formats, null));
        Assert.assertEquals((Object)TestDateUtils.createDate(1905, 9, 14), (Object)DateUtils.parseDate((String)"Friday, 14-Oct-05 00:00:00 GMT", (String[])formats, (Date)TestDateUtils.createDate(1900, 0, 0)));
    }

    @Test
    public void testParseQuotedDate() throws Exception {
        Date date1 = TestDateUtils.createDate(2005, 9, 14);
        String[] formats = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"};
        Date date2 = DateUtils.parseDate((String)"'Fri, 14 Oct 2005 00:00:00 GMT'", (String[])formats);
        Assert.assertEquals((Object)date1, (Object)date2);
    }

    @Test
    public void testBasicDateFormat() throws Exception {
        Date date = TestDateUtils.createDate(2005, 9, 14);
        Assert.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatDate((Date)date));
        Assert.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatDate((Date)date, (String)"EEE, dd MMM yyyy HH:mm:ss zzz"));
    }

    @Test
    public void testIsBefore() throws Exception {
        HeaderGroup message1 = new HeaderGroup();
        HeaderGroup message2 = new HeaderGroup();
        Assert.assertThat((Object)DateUtils.isBefore(null, null, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)DateUtils.isBefore((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"huh?"));
        message2.setHeader((Header)new BasicHeader("Date", (Object)"eh?"));
        Assert.assertThat((Object)DateUtils.isBefore((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"huh?"));
        message2.setHeader((Header)new BasicHeader("Date", (Object)"Tuesday, 26-Dec-2017 00:00:00 GMT"));
        Assert.assertThat((Object)DateUtils.isBefore((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Wednesday, 25-Dec-2017 00:00:00 GMT"));
        Assert.assertThat((Object)DateUtils.isBefore((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)true));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Thursday, 27-Dec-2017 00:00:00 GMT"));
        Assert.assertThat((Object)DateUtils.isBefore((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testIsAfter() throws Exception {
        HeaderGroup message1 = new HeaderGroup();
        HeaderGroup message2 = new HeaderGroup();
        Assert.assertThat((Object)DateUtils.isAfter(null, null, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((Object)DateUtils.isAfter((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"huh?"));
        message2.setHeader((Header)new BasicHeader("Date", (Object)"eh?"));
        Assert.assertThat((Object)DateUtils.isAfter((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"huh?"));
        message2.setHeader((Header)new BasicHeader("Date", (Object)"Tuesday, 26-Dec-2017 00:00:00 GMT"));
        Assert.assertThat((Object)DateUtils.isAfter((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Thursday, 27-Dec-2017 00:00:00 GMT"));
        Assert.assertThat((Object)DateUtils.isAfter((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)true));
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Wednesday, 25-Dec-2017 00:00:00 GMT"));
        Assert.assertThat((Object)DateUtils.isAfter((MessageHeaders)message1, (MessageHeaders)message2, (String)"Date"), (Matcher)CoreMatchers.equalTo((Object)false));
    }
}

