/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultConnKeepAliveStrategy {
    @Test(expected=IllegalArgumentException.class)
    public void testIllegalResponseArg() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        keepAliveStrat.getKeepAliveDuration(null, (HttpContext)context);
    }

    @Test
    public void testNoKeepAliveHeader() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        long d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((long)-1L, (long)d);
    }

    @Test
    public void testEmptyKeepAliveHeader() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        response.addHeader("Keep-Alive", "timeout, max=20");
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        long d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((long)-1L, (long)d);
    }

    @Test
    public void testInvalidKeepAliveHeader() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        response.addHeader("Keep-Alive", "timeout=whatever, max=20");
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        long d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((long)-1L, (long)d);
    }

    @Test
    public void testKeepAliveHeader() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK"));
        response.addHeader("Keep-Alive", "timeout=300, max=20");
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        long d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assert.assertEquals((long)300000L, (long)d);
    }
}

