/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.RedirectException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.RedirectExec;
import org.apache.http.protocol.HttpContext;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestRedirectExec {
    @Mock
    private ClientExecChain requestExecutor;
    @Mock
    private HttpRoutePlanner httpRoutePlanner;
    @Mock
    private RedirectStrategy redirectStrategy;
    @Mock
    private HttpExecutionAware execAware;
    private RedirectExec redirectExec;
    private HttpHost target;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.redirectExec = new RedirectExec(this.requestExecutor, this.httpRoutePlanner, this.redirectStrategy);
        this.target = new HttpHost("localhost", 80);
    }

    @Test
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        get.addHeader("header", "this");
        get.addHeader("header", "that");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response1 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpEntity entity1 = EntityBuilder.create().setStream(inStream1).build();
        Mockito.when((Object)response1.getEntity()).thenReturn((Object)entity1);
        CloseableHttpResponse response2 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        InputStream inStream2 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpEntity entity2 = EntityBuilder.create().setStream(inStream2).build();
        Mockito.when((Object)response2.getEntity()).thenReturn((Object)entity2);
        HttpGet redirect = new HttpGet("http://localhost:80/redirect");
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), HttpRequestWrapperMatcher.same((HttpRequest)redirect), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response2);
        Mockito.when((Object)this.redirectStrategy.isRedirected((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.redirectStrategy.getRedirect((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)redirect);
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)Mockito.eq((Object)this.target), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        this.redirectExec.execute(route, request, context, this.execAware);
        ArgumentCaptor reqCaptor = ArgumentCaptor.forClass(HttpRequestWrapper.class);
        ((ClientExecChain)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)2))).execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)reqCaptor.capture(), (HttpClientContext)Mockito.same((Object)context), (HttpExecutionAware)Mockito.same((Object)this.execAware));
        List allValues = reqCaptor.getAllValues();
        Assert.assertNotNull((Object)allValues);
        Assert.assertEquals((long)2L, (long)allValues.size());
        Assert.assertSame((Object)request, allValues.get(0));
        HttpRequestWrapper redirectWrapper = (HttpRequestWrapper)allValues.get(1);
        Header[] headers = redirectWrapper.getHeaders("header");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Assert.assertEquals((Object)"this", (Object)headers[0].getValue());
        Assert.assertEquals((Object)"that", (Object)headers[1].getValue());
        ((CloseableHttpResponse)Mockito.verify((Object)response1, (VerificationMode)Mockito.times((int)1))).close();
        ((InputStream)Mockito.verify((Object)inStream1, (VerificationMode)Mockito.times((int)1))).close();
        ((CloseableHttpResponse)Mockito.verify((Object)response2, (VerificationMode)Mockito.never())).close();
        ((InputStream)Mockito.verify((Object)inStream2, (VerificationMode)Mockito.never())).close();
    }

    @Test(expected=RedirectException.class)
    public void testMaxRedirect() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(true).setMaxRedirects(3).build();
        context.setRequestConfig(config);
        CloseableHttpResponse response1 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpGet redirect = new HttpGet("http://localhost:80/redirect");
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.redirectStrategy.isRedirected((HttpRequest)Mockito.any(), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.redirectStrategy.getRedirect((HttpRequest)Mockito.any(), (HttpResponse)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)redirect);
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)Mockito.eq((Object)this.target), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        this.redirectExec.execute(route, request, context, this.execAware);
    }

    @Test(expected=HttpException.class)
    public void testRelativeRedirect() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response1 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        CloseableHttpResponse response2 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpGet redirect = new HttpGet("/redirect");
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), HttpRequestWrapperMatcher.same((HttpRequest)redirect), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response2);
        Mockito.when((Object)this.redirectStrategy.isRedirected((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.redirectStrategy.getRedirect((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)redirect);
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)Mockito.eq((Object)this.target), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)route);
        this.redirectExec.execute(route, request, context, this.execAware);
    }

    @Test
    public void testCrossSiteRedirect() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        AuthState targetAuthState = new AuthState();
        targetAuthState.setState(AuthProtocolState.SUCCESS);
        targetAuthState.update((AuthScheme)new BasicScheme(), (Credentials)new UsernamePasswordCredentials("user", "pass"));
        AuthState proxyAuthState = new AuthState();
        proxyAuthState.setState(AuthProtocolState.SUCCESS);
        proxyAuthState.update((AuthScheme)new NTLMScheme(), (Credentials)new NTCredentials("user", "pass", null, null));
        context.setAttribute("http.auth.target-scope", (Object)targetAuthState);
        context.setAttribute("http.auth.proxy-scope", (Object)proxyAuthState);
        CloseableHttpResponse response1 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        CloseableHttpResponse response2 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        HttpGet redirect = new HttpGet("http://otherhost/redirect");
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), HttpRequestWrapperMatcher.same((HttpRequest)redirect), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response2);
        Mockito.when((Object)this.redirectStrategy.isRedirected((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.redirectStrategy.getRedirect((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)redirect);
        Mockito.when((Object)this.httpRoutePlanner.determineRoute((HttpHost)Mockito.eq((Object)this.target), (HttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)new HttpRoute(new HttpHost("otherhost", 80)));
        this.redirectExec.execute(route, request, context, this.execAware);
        Assert.assertNotNull((Object)context.getTargetAuthState());
        Assert.assertEquals((Object)AuthProtocolState.UNCHALLENGED, (Object)context.getTargetAuthState().getState());
        Assert.assertEquals(null, (Object)context.getTargetAuthState().getAuthScheme());
        Assert.assertNotNull((Object)context.getProxyAuthState());
        Assert.assertEquals((Object)AuthProtocolState.UNCHALLENGED, (Object)context.getProxyAuthState().getState());
        Assert.assertEquals(null, (Object)context.getProxyAuthState().getAuthScheme());
    }

    @Test(expected=RuntimeException.class)
    public void testRedirectRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response1 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.redirectStrategy.isRedirected((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        Mockito.doThrow((Throwable)new RuntimeException("Oppsie")).when((Object)this.redirectStrategy.getRedirect((HttpRequest)Mockito.same((Object)request), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any()));
        try {
            this.redirectExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((CloseableHttpResponse)Mockito.verify((Object)response1)).close();
            throw ex;
        }
    }

    @Test(expected=ProtocolException.class)
    public void testRedirectProtocolException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response1 = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        InputStream inStream1 = (InputStream)Mockito.spy((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpEntity entity1 = EntityBuilder.create().setStream(inStream1).build();
        Mockito.when((Object)response1.getEntity()).thenReturn((Object)entity1);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response1);
        Mockito.when((Object)this.redirectStrategy.isRedirected((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        ((RedirectStrategy)Mockito.doThrow((Throwable)new ProtocolException("Oppsie")).when((Object)this.redirectStrategy)).getRedirect((HttpRequest)Mockito.same((Object)get), (HttpResponse)Mockito.same((Object)response1), (HttpContext)Mockito.any());
        try {
            this.redirectExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((InputStream)Mockito.verify((Object)inStream1)).close();
            ((CloseableHttpResponse)Mockito.verify((Object)response1)).close();
            throw ex;
        }
    }

    static class HttpRequestWrapperMatcher
    extends ArgumentMatcher<HttpRequestWrapper> {
        private final HttpRequest original;

        HttpRequestWrapperMatcher(HttpRequest original) {
            this.original = original;
        }

        public boolean matches(Object obj) {
            HttpRequestWrapper wrapper = (HttpRequestWrapper)obj;
            return this.original == wrapper.getOriginal();
        }

        static HttpRequestWrapper same(HttpRequest original) {
            return (HttpRequestWrapper)Matchers.argThat((Matcher)new HttpRequestWrapperMatcher(original));
        }
    }
}

