/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestRequestDefaultHeaders {
    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders();
        interceptor.process(null, (HttpContext)context);
    }

    @Test
    public void testNoDefaultHeadersForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", "stuff"));
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders(defheaders);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("custom");
        Assert.assertNull((Object)header1);
    }

    @Test
    public void testDefaultHeaders() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("custom", "stuff");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", "more stuff"));
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders(defheaders);
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers = request.getHeaders("custom");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)2L, (long)headers.length);
        Assert.assertEquals((Object)"stuff", (Object)headers[0].getValue());
        Assert.assertEquals((Object)"more stuff", (Object)headers[1].getValue());
    }
}

