/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBasicAuthCache {
    @Test
    public void testBasicStoreRestore() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        Assert.assertNotNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.remove(new HttpHost("localhost", 80));
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        cache.clear();
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullKey() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        cache.put(null, (AuthScheme)authScheme);
    }

    @Test
    public void testNullAuthScheme() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        cache.put(new HttpHost("localhost", 80), null);
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    @Test
    public void testGetKey() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        HttpHost target = new HttpHost("localhost", 443, "https");
        Assert.assertSame((Object)target, (Object)cache.getKey(target));
        Assert.assertEquals((Object)target, (Object)cache.getKey(new HttpHost("localhost", -1, "https")));
    }

    @Test
    public void testGetKeyWithSchemeRegistry() throws Exception {
        SchemePortResolver schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        BasicAuthCache cache = new BasicAuthCache(schemePortResolver);
        Mockito.when((Object)schemePortResolver.resolve(new HttpHost("localhost", -1, "https"))).thenReturn((Object)443);
        HttpHost target = new HttpHost("localhost", 443, "https");
        Assert.assertSame((Object)target, (Object)cache.getKey(target));
        Assert.assertEquals((Object)target, (Object)cache.getKey(new HttpHost("localhost", -1, "https")));
    }

    @Test
    public void testStoreNonserializable() throws Exception {
        BasicAuthCache cache = new BasicAuthCache();
        NTLMScheme authScheme = new NTLMScheme();
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        Assert.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }
}

