/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.localserver.RandomHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConnectionReuse
extends LocalServerTestBase {
    @Test
    public void testReuseOfPersistentConnections() throws Exception {
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("TEST/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build();
        this.serverBootstrap.setHttpProcessor(httpproc).registerHandler("/random/*", (HttpRequestHandler)new RandomHandler());
        this.connManager.setMaxTotal(5);
        this.connManager.setDefaultMaxPerRoute(5);
        HttpHost target = this.start();
        WorkerThread[] workers = new WorkerThread[10];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)this.httpclient, target, new URI("/random/2000"), 10, false);
        }
        for (WorkerThread worker : workers) {
            worker.start();
        }
        for (WorkerThread worker : workers) {
            worker.join(10000L);
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        Assert.assertTrue((this.connManager.getTotalStats().getAvailable() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReuseOfClosedConnections() throws Exception {
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("TEST/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new AlwaysCloseConn()).build();
        this.serverBootstrap.setHttpProcessor(httpproc).registerHandler("/random/*", (HttpRequestHandler)new RandomHandler());
        this.connManager.setMaxTotal(5);
        this.connManager.setDefaultMaxPerRoute(5);
        HttpHost target = this.start();
        WorkerThread[] workers = new WorkerThread[10];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)this.httpclient, target, new URI("/random/2000"), 10, false);
        }
        for (WorkerThread worker : workers) {
            worker.start();
        }
        for (WorkerThread worker : workers) {
            worker.join(10000L);
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        Assert.assertEquals((long)0L, (long)this.connManager.getTotalStats().getAvailable());
    }

    @Test
    public void testReuseOfAbortedConnections() throws Exception {
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("TEST/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build();
        this.serverBootstrap.setHttpProcessor(httpproc).registerHandler("/random/*", (HttpRequestHandler)new RandomHandler());
        this.connManager.setMaxTotal(5);
        this.connManager.setDefaultMaxPerRoute(5);
        HttpHost target = this.start();
        WorkerThread[] workers = new WorkerThread[10];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)this.httpclient, target, new URI("/random/2000"), 10, true);
        }
        for (WorkerThread worker : workers) {
            worker.start();
        }
        for (WorkerThread worker : workers) {
            worker.join(10000L);
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        Assert.assertEquals((long)0L, (long)this.connManager.getTotalStats().getAvailable());
    }

    @Test
    public void testKeepAliveHeaderRespected() throws Exception {
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("TEST/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).add((HttpResponseInterceptor)new ResponseKeepAlive()).build();
        this.serverBootstrap.setHttpProcessor(httpproc).registerHandler("/random/*", (HttpRequestHandler)new RandomHandler());
        this.connManager.setMaxTotal(1);
        this.connManager.setDefaultMaxPerRoute(1);
        HttpHost target = this.start();
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)this.connManager.getTotalStats().getAvailable());
        response = this.httpclient.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)this.connManager.getTotalStats().getAvailable());
        Thread.sleep(1100L);
        response = this.httpclient.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)this.connManager.getTotalStats().getAvailable());
        Thread.sleep(500L);
        response = this.httpclient.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)this.connManager.getTotalStats().getAvailable());
    }

    private static class ResponseKeepAlive
    implements HttpResponseInterceptor {
        private ResponseKeepAlive() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header connection = response.getFirstHeader("Connection");
            if (connection != null && !connection.getValue().equalsIgnoreCase("Close")) {
                response.addHeader("Keep-Alive", "timeout=1");
            }
        }
    }

    private static class WorkerThread
    extends Thread {
        private final URI requestURI;
        private final HttpHost target;
        private final HttpClient httpclient;
        private final int repetitions;
        private final boolean forceClose;
        private volatile Exception exception;

        public WorkerThread(HttpClient httpclient, HttpHost target, URI requestURI, int repetitions, boolean forceClose) {
            this.httpclient = httpclient;
            this.requestURI = requestURI;
            this.target = target;
            this.repetitions = repetitions;
            this.forceClose = forceClose;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.repetitions; ++i) {
                    HttpGet httpget = new HttpGet(this.requestURI);
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)httpget);
                    if (this.forceClose) {
                        httpget.abort();
                        continue;
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }

    private static class AlwaysCloseConn
    implements HttpResponseInterceptor {
        private AlwaysCloseConn() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setHeader("Connection", "Close");
        }
    }
}

