/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.IdleConnectionEvictor;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.util.EntityUtils;
import org.junit.Test;

public class TestIdleConnectionEviction
extends LocalServerTestBase {
    @Test
    public void testIdleConnectionEviction() throws Exception {
        this.connManager.setDefaultMaxPerRoute(10);
        this.connManager.setMaxTotal(50);
        HttpHost target = this.start();
        IdleConnectionEvictor idleConnectionMonitor = new IdleConnectionEvictor((HttpClientConnectionManager)this.connManager, 50L, TimeUnit.MILLISECONDS);
        idleConnectionMonitor.start();
        HttpGet httpget = new HttpGet("/random/1024");
        WorkerThread[] workers = new WorkerThread[5];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)this.httpclient, target, (HttpUriRequest)httpget, 200);
        }
        for (WorkerThread worker : workers) {
            worker.start();
        }
        for (WorkerThread worker : workers) {
            worker.join();
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        idleConnectionMonitor.shutdown();
    }

    static class WorkerThread
    extends Thread {
        private final HttpClient httpclient;
        private final HttpHost target;
        private final HttpUriRequest request;
        private final int count;
        private volatile Exception ex;

        public WorkerThread(HttpClient httpclient, HttpHost target, HttpUriRequest request, int count) {
            this.httpclient = httpclient;
            this.target = target;
            this.request = request;
            this.count = count;
        }

        @Override
        public void run() {
            try {
                for (int i = 0; i < this.count; ++i) {
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)this.request);
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 200) {
                        this.request.abort();
                        throw new ClientProtocolException("Unexpected status code: " + status);
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    Thread.sleep(10L);
                }
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

