/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.PublicSuffixDomainFilter;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestBasicCookieAttribHandlers {
    @Test
    public void testBasicDomainParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicDomainHandler h = new BasicDomainHandler();
        h.parse((SetCookie)cookie, "www.somedomain.com");
        Assert.assertEquals((Object)"www.somedomain.com", (Object)cookie.getDomain());
    }

    @Test(expected=MalformedCookieException.class)
    public void testBasicDomainParseInvalid1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicDomainHandler h = new BasicDomainHandler();
        h.parse((SetCookie)cookie, "");
    }

    @Test(expected=MalformedCookieException.class)
    public void testBasicDomainParseInvalid2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicDomainHandler h = new BasicDomainHandler();
        h.parse((SetCookie)cookie, null);
    }

    @Test
    public void testBasicDomainValidate1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain(".somedomain.com");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain(".otherdomain.com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
        cookie.setDomain("www.otherdomain.com");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testBasicDomainValidate2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain("somehost");
        h.validate((Cookie)cookie, origin);
        cookie.setDomain("otherhost");
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testBasicDomainValidate3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain(".somedomain.com");
        h.validate((Cookie)cookie, origin);
    }

    @Test
    public void testBasicDomainValidate4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain(null);
        try {
            h.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
    }

    @Test
    public void testBasicDomainMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somedomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain("somedomain.com");
        cookie.setAttribute("domain", "somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(".somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("www.somedomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain("somedomain.com");
        cookie.setAttribute("domain", "somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(".somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
        cookie.setDomain(null);
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainMatchOneLetterPrefix() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("a.somedomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain("somedomain.com");
        cookie.setAttribute("domain", "somedomain.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainMatchMixedCase() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("a.SomeDomain.com", 80, "/", false);
        BasicDomainHandler h = new BasicDomainHandler();
        cookie.setDomain("somedoMain.Com");
        cookie.setAttribute("domain", "somedoMain.Com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicDomainInvalidInput() throws Exception {
        BasicDomainHandler h = new BasicDomainHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.validate(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.validate((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicPathParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicPathHandler h = new BasicPathHandler();
        h.parse((SetCookie)cookie, "stuff");
        Assert.assertEquals((Object)"stuff", (Object)cookie.getPath());
        h.parse((SetCookie)cookie, "");
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        h.parse((SetCookie)cookie, null);
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
    }

    @Test
    public void testBasicPathMatch1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff", false);
        BasicPathHandler h = new BasicPathHandler();
        cookie.setPath("/stuff");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff/", false);
        BasicPathHandler h = new BasicPathHandler();
        cookie.setPath("/stuff");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff/more-stuff", false);
        BasicPathHandler h = new BasicPathHandler();
        cookie.setPath("/stuff");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuffed", false);
        BasicPathHandler h = new BasicPathHandler();
        cookie.setPath("/stuff");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch5() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/otherstuff", false);
        BasicPathHandler h = new BasicPathHandler();
        cookie.setPath("/stuff");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch6() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff", false);
        BasicPathHandler h = new BasicPathHandler();
        cookie.setPath("/stuff/");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathMatch7() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        CookieOrigin origin = new CookieOrigin("somehost", 80, "/stuff", false);
        BasicPathHandler h = new BasicPathHandler();
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin));
    }

    @Test
    public void testBasicPathInvalidInput() throws Exception {
        BasicPathHandler h = new BasicPathHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicMaxAgeParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicMaxAgeHandler h = new BasicMaxAgeHandler();
        h.parse((SetCookie)cookie, "2000");
        Assert.assertNotNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testBasicMaxAgeParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicMaxAgeHandler h = new BasicMaxAgeHandler();
        try {
            h.parse((SetCookie)cookie, "garbage");
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
        try {
            h.parse((SetCookie)cookie, null);
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicMaxAgeInvalidInput() throws Exception {
        BasicMaxAgeHandler h = new BasicMaxAgeHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicCommentParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicCommentHandler h = new BasicCommentHandler();
        h.parse((SetCookie)cookie, "whatever");
        Assert.assertEquals((Object)"whatever", (Object)cookie.getComment());
        h.parse((SetCookie)cookie, null);
        Assert.assertEquals(null, (Object)cookie.getComment());
    }

    @Test
    public void testBasicCommentInvalidInput() throws Exception {
        BasicCommentHandler h = new BasicCommentHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicSecureParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicSecureHandler h = new BasicSecureHandler();
        h.parse((SetCookie)cookie, "whatever");
        Assert.assertTrue((boolean)cookie.isSecure());
        h.parse((SetCookie)cookie, null);
        Assert.assertTrue((boolean)cookie.isSecure());
    }

    @Test
    public void testBasicSecureMatch() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicSecureHandler h = new BasicSecureHandler();
        CookieOrigin origin1 = new CookieOrigin("somehost", 80, "/stuff", false);
        cookie.setSecure(false);
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin1));
        cookie.setSecure(true);
        Assert.assertFalse((boolean)h.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("somehost", 80, "/stuff", true);
        cookie.setSecure(false);
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin2));
        cookie.setSecure(true);
        Assert.assertTrue((boolean)h.match((Cookie)cookie, origin2));
    }

    @Test
    public void testBasicSecureInvalidInput() throws Exception {
        BasicSecureHandler h = new BasicSecureHandler();
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            h.match((Cookie)new BasicClientCookie("name", "value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicExpiresParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicExpiresHandler h = new BasicExpiresHandler(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        SimpleDateFormat dateformat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        dateformat.setTimeZone(DateUtils.GMT);
        Date now = new Date();
        h.parse((SetCookie)cookie, dateformat.format(now));
        Assert.assertNotNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testBasicExpiresParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        BasicExpiresHandler h = new BasicExpiresHandler(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        try {
            h.parse((SetCookie)cookie, "garbage");
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException ex) {
            // empty catch block
        }
        try {
            h.parse((SetCookie)cookie, null);
            Assert.fail((String)"MalformedCookieException must have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testBasicExpiresInvalidInput() throws Exception {
        try {
            new BasicExpiresHandler(null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        BasicExpiresHandler h = new BasicExpiresHandler(new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        try {
            h.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPublicSuffixFilter() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        PublicSuffixMatcher matcher = new PublicSuffixMatcher(DomainType.ICANN, Arrays.asList("co.uk", "com"), null);
        PublicSuffixDomainFilter h = new PublicSuffixDomainFilter((CommonCookieAttributeHandler)new RFC2109DomainHandler(), matcher);
        cookie.setDomain(".co.uk");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.uk", 80, "/stuff", false)));
        cookie.setDomain("co.uk");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.uk", 80, "/stuff", false)));
        cookie.setDomain(".co.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.com", 80, "/stuff", false)));
        cookie.setDomain("co.com");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.co.com", 80, "/stuff", false)));
        cookie.setDomain(".com");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.com", 80, "/stuff", false)));
        cookie.setDomain("com");
        Assert.assertFalse((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.com", 80, "/stuff", false)));
        cookie.setDomain("apache.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("apache.com", 80, "/stuff", false)));
        cookie.setDomain(".apache.com");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("www.apache.com", 80, "/stuff", false)));
        cookie.setDomain("localhost");
        Assert.assertTrue((boolean)h.match((Cookie)cookie, new CookieOrigin("localhost", 80, "/stuff", false)));
    }
}

