/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Calendar;
import java.util.Date;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.LaxExpiresHandler;
import org.apache.http.impl.cookie.LaxMaxAgeHandler;
import org.junit.Assert;
import org.junit.Test;

public class TestLaxCookieAttribHandlers {
    @Test
    public void testParseMaxAge() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = new LaxMaxAgeHandler();
        h.parse((SetCookie)cookie, "2000");
        Assert.assertNotNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testParseMaxNegative() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = new LaxMaxAgeHandler();
        h.parse((SetCookie)cookie, "-2000");
        Assert.assertNotNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testParseMaxZero() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = new LaxMaxAgeHandler();
        h.parse((SetCookie)cookie, "0000");
        Assert.assertNotNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testBasicMaxAgeParseEmpty() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = new LaxMaxAgeHandler();
        h.parse((SetCookie)cookie, "  ");
        Assert.assertNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testBasicMaxAgeParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = new LaxMaxAgeHandler();
        h.parse((SetCookie)cookie, "garbage");
        Assert.assertNull((Object)cookie.getExpiryDate());
    }

    @Test
    public void testBasicMaxAgeInvalidInput() throws Exception {
        LaxMaxAgeHandler h = new LaxMaxAgeHandler();
        try {
            h.parse(null, "stuff");
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=MalformedCookieException.class)
    public void testExpiryGarbage() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, ";;blah,blah;yada  ");
    }

    @Test
    public void testParseExpiry() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:0:12 8-jan-2012");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)2012L, (long)c.get(1));
        Assert.assertEquals((long)0L, (long)c.get(2));
        Assert.assertEquals((long)8L, (long)c.get(5));
        Assert.assertEquals((long)1L, (long)c.get(11));
        Assert.assertEquals((long)0L, (long)c.get(12));
        Assert.assertEquals((long)12L, (long)c.get(13));
        Assert.assertEquals((long)0L, (long)c.get(14));
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidTime1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:0:122 8 dec 1980");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidTime2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "24:00:00 8 dec 1980");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidTime3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:60:00 8 dec 1980");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidTime4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:00:60 8 dec 1980");
    }

    @Test
    public void testParseExpiryFunnyTime() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:59:00blah; 8-feb-2000");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)2000L, (long)c.get(1));
        Assert.assertEquals((long)1L, (long)c.get(2));
        Assert.assertEquals((long)8L, (long)c.get(5));
        Assert.assertEquals((long)1L, (long)c.get(11));
        Assert.assertEquals((long)59L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        Assert.assertEquals((long)0L, (long)c.get(14));
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidDayOfMonth1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "12:00:00 888 mar 1880");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidDayOfMonth2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "12:00:00 0 mar 1880");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidDayOfMonth3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "12:00:00 32 mar 1880");
    }

    @Test
    public void testParseExpiryFunnyDayOfMonth() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "12:00:00 8blah;mar;1880");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)1880L, (long)c.get(1));
        Assert.assertEquals((long)2L, (long)c.get(2));
        Assert.assertEquals((long)8L, (long)c.get(5));
        Assert.assertEquals((long)12L, (long)c.get(11));
        Assert.assertEquals((long)0L, (long)c.get(12));
        Assert.assertEquals((long)0L, (long)c.get(13));
        Assert.assertEquals((long)0L, (long)c.get(14));
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidMonth() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:00:00 8 dek 80");
    }

    @Test
    public void testParseExpiryFunnyMonth() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:59:59; 1-ApriLLLLL-2008");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)2008L, (long)c.get(1));
        Assert.assertEquals((long)3L, (long)c.get(2));
        Assert.assertEquals((long)1L, (long)c.get(5));
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)59L, (long)c.get(12));
        Assert.assertEquals((long)59L, (long)c.get(13));
        Assert.assertEquals((long)0L, (long)c.get(14));
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidYearTooShort() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:00:00 8 dec 8");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidYearTooLong() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:00:00 8 dec 88888");
    }

    @Test(expected=MalformedCookieException.class)
    public void testParseExpiryInvalidYearTooLongAgo() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "1:00:00 8 dec 1600");
    }

    @Test
    public void testParseExpiryFunnyYear() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-2008blah");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)2008L, (long)c.get(1));
        Assert.assertEquals((long)3L, (long)c.get(2));
        Assert.assertEquals((long)1L, (long)c.get(5));
        Assert.assertEquals((long)23L, (long)c.get(11));
        Assert.assertEquals((long)59L, (long)c.get(12));
        Assert.assertEquals((long)59L, (long)c.get(13));
        Assert.assertEquals((long)0L, (long)c.get(14));
    }

    @Test
    public void testParseExpiryYearTwoDigit1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-70");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)1970L, (long)c.get(1));
    }

    @Test
    public void testParseExpiryYearTwoDigit2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-99");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)1999L, (long)c.get(1));
    }

    @Test
    public void testParseExpiryYearTwoDigit3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = new LaxExpiresHandler();
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-00");
        Date expiryDate = cookie.getExpiryDate();
        Assert.assertNotNull((Object)expiryDate);
        Calendar c = Calendar.getInstance();
        c.setTimeZone(LaxExpiresHandler.UTC);
        c.setTime(expiryDate);
        Assert.assertEquals((long)2000L, (long)c.get(1));
    }
}

