/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.jxr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.jxr.pacman.ClassType;
import org.apache.maven.jxr.pacman.FileManager;
import org.apache.maven.jxr.pacman.ImportType;
import org.apache.maven.jxr.pacman.JavaFile;
import org.apache.maven.jxr.pacman.PackageManager;
import org.apache.maven.jxr.pacman.PackageType;
import org.apache.maven.jxr.util.SimpleWordTokenizer;
import org.apache.maven.jxr.util.StringEntry;

public class JavaCodeTransform
implements Serializable {
    public static final boolean LINE_NUMBERS = true;
    public static final String COMMENT_START = "<em class=\"jxr_comment\">";
    public static final String COMMENT_END = "</em>";
    public static final String JAVADOC_COMMENT_START = "<em class=\"jxr_javadoccomment\">";
    public static final String JAVADOC_COMMENT_END = "</em>";
    public static final String STRING_START = "<span class=\"jxr_string\">";
    public static final String STRING_END = "</span>";
    public static final String RESERVED_WORD_START = "<strong class=\"jxr_keyword\">";
    public static final String RESERVED_WORD_END = "</strong>";
    public static final String STYLESHEET_FILENAME = "stylesheet.css";
    public static final String[] VALID_URI_SCHEMES = new String[]{"http://", "mailto:"};
    public static final char[] VALID_URI_CHARS = new char[]{'?', '+', '%', '&', ':', '/', '.', '@', '_', ';', '=', '$', ',', '-', '!', '~', '*', '\'', '(', ')'};
    private Hashtable<String, String> reservedWords = new Hashtable();
    private boolean inMultiLineComment = false;
    private boolean inJavadocComment = false;
    private String currentFilename = null;
    private String revision = null;
    private String sourcefile = null;
    private String destfile = null;
    private String sourcedir = null;
    private String inputEncoding = null;
    private String outputEncoding = null;
    private Locale locale = null;
    private String javadocLinkDir;
    private PackageManager packageManager;
    private FileManager fileManager;

    public JavaCodeTransform(PackageManager packageManager) {
        this.packageManager = packageManager;
        this.loadHash();
        this.fileManager = packageManager.getFileManager();
    }

    public final String syntaxHighlight(String line) {
        return this.htmlFilter(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendHeader(PrintWriter out) {
        String outputEncoding = this.outputEncoding;
        if (outputEncoding == null) {
            outputEncoding = "ISO-8859-1";
        }
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.print("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"");
        out.print(this.locale);
        out.print("\" lang=\"");
        out.print(this.locale);
        out.println("\">");
        out.print("<head>");
        out.print("<meta http-equiv=\"content-type\" content=\"text/html; charset=");
        out.print(outputEncoding);
        out.println("\" />");
        out.print("<title>");
        try {
            JavaFile javaFile = this.fileManager.getFile(this.getCurrentFilename());
            if (javaFile.getClassType() != null && javaFile.getClassType().getFilename() != null) {
                out.print(javaFile.getClassType().getFilename());
            } else {
                out.print(this.getCurrentFilename());
            }
            out.print(" ");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            out.println("xref</title>");
        }
        out.print("<link type=\"text/css\" rel=\"stylesheet\" href=\"");
        out.print(this.getPackageRoot());
        out.print(STYLESHEET_FILENAME);
        out.println("\" />");
        out.println("</head>");
        out.println("<body>");
        out.print(this.getFileOverview());
        out.println("<pre>");
    }

    public final void appendFooter(PrintWriter out, String bottom) {
        out.println("</pre>");
        out.println("<hr/>");
        out.print("<div id=\"footer\">");
        out.print(bottom);
        out.println("</div>");
        out.println("</body>");
        out.println("</html>");
    }

    public final void transform(Reader sourceReader, Writer destWriter, Locale locale, String inputEncoding, String outputEncoding, String javadocLinkDir, String revision, String bottom) throws IOException {
        this.locale = locale;
        this.inputEncoding = inputEncoding;
        this.outputEncoding = outputEncoding;
        this.javadocLinkDir = javadocLinkDir;
        this.revision = revision;
        BufferedReader in = new BufferedReader(sourceReader);
        PrintWriter out = new PrintWriter(destWriter);
        String line = "";
        this.appendHeader(out);
        int linenumber = 1;
        while ((line = in.readLine()) != null) {
            out.print("<a class=\"jxr_linenumber\" name=\"L" + linenumber + "\" " + "href=\"#L" + linenumber + "\">" + linenumber + "</a>" + this.getLineWidth(linenumber));
            out.println(this.syntaxHighlight(line));
            ++linenumber;
        }
        this.appendFooter(out, bottom);
        out.flush();
    }

    public final void transform(String sourcefile, String destfile, Locale locale, String inputEncoding, String outputEncoding, String javadocLinkDir, String revision, String bottom) throws IOException {
        this.setCurrentFilename(sourcefile);
        this.sourcefile = sourcefile;
        this.destfile = destfile;
        new File(new File(destfile).getParent()).mkdirs();
        InputStreamReader fr = null;
        Writer fw = null;
        try {
            fr = inputEncoding != null ? new InputStreamReader((InputStream)new FileInputStream(sourcefile), inputEncoding) : new FileReader(sourcefile);
            fw = outputEncoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(destfile), outputEncoding) : new FileWriter(destfile);
            this.transform(fr, fw, locale, inputEncoding, outputEncoding, javadocLinkDir, revision, bottom);
        }
        catch (RuntimeException e) {
            System.out.println("Unable to processPath " + sourcefile + " => " + destfile);
            throw e;
        }
        finally {
            if (fr != null) {
                try {
                    ((Reader)fr).close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public final String getCurrentFilename() {
        return this.currentFilename;
    }

    public final void setCurrentFilename(String filename) {
        this.currentFilename = filename;
    }

    public final String getPackageRoot() {
        StringBuffer buff = new StringBuffer();
        JavaFile jf = null;
        try {
            jf = this.fileManager.getFile(this.getCurrentFilename());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String current = jf.getPackageType().getName();
        int count = this.getPackageCount(current);
        for (int i = 0; i < count; ++i) {
            buff.append("../");
        }
        return buff.toString();
    }

    public final String uriFilter(String line) {
        for (int i = 0; i < VALID_URI_SCHEMES.length; ++i) {
            String scheme = VALID_URI_SCHEMES[i];
            int index = line.indexOf(scheme);
            if (index == -1) continue;
            int start = index;
            int end = -1;
            int j = start;
            while (j < line.length()) {
                char current = line.charAt(j);
                if (!Character.isLetterOrDigit(current) && this.isInvalidURICharacter(current)) {
                    end = j;
                    break;
                }
                end = j++;
            }
            if (end == -1) continue;
            String uri = line.substring(start, end);
            line = StringUtils.replace((String)line, (String)uri, (String)("<a href=\"" + uri + "\" target=\"alexandria_uri\">" + uri + "</a>"));
        }
        if (!this.inMultiLineComment && !this.inJavadocComment) {
            return this.jxrFilter(line);
        }
        return line;
    }

    public final String getRevision() {
        return this.revision;
    }

    public final String getSourcefile() {
        return this.sourcefile;
    }

    public final String getDestfile() {
        return this.destfile;
    }

    public final String getSourceDirectory() {
        return this.sourcedir;
    }

    public final String xrLine(String line, String packageName, ClassType classType) {
        StringBuffer buff = new StringBuffer(line);
        String link = null;
        String find = null;
        String href = null;
        if (classType != null) {
            href = this.getHREF(packageName, classType);
            find = classType.getName();
        } else {
            href = this.getHREF(packageName);
            find = packageName;
        }
        String replace = link = "<a href=\"" + href + "\">" + find + "</a>";
        StringEntry[] tokens = SimpleWordTokenizer.tokenize(buff.toString(), find);
        for (int l = 0; l < tokens.length; ++l) {
            int start = tokens[l].getIndex();
            int end = tokens[l].getIndex() + find.length();
            buff.replace(start, end, replace);
        }
        return buff.toString();
    }

    public final String xrLine(String line, String packageName) {
        String href = this.getHREF(packageName);
        String find = packageName;
        String link = "<a href=\"" + href + "\">" + find + "</a>";
        return StringUtils.replace((String)line, (String)find, (String)link);
    }

    private String htmlFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        line = this.replace(line, "&", "&amp;");
        line = this.replace(line, "<", "&lt;");
        line = this.replace(line, ">", "&gt;");
        line = this.replace(line, "\\\\", "&#92;&#92;");
        line = this.replace(line, "\\\"", "\\&quot;");
        line = this.replace(line, "'\"'", "'&quot;'");
        return this.ongoingMultiLineCommentFilter(line);
    }

    private String ongoingMultiLineCommentFilter(String line) {
        String[] tags;
        String[] stringArray;
        if (line == null || line.equals("")) {
            return "";
        }
        if (this.inJavadocComment) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = JAVADOC_COMMENT_START;
            stringArray = stringArray2;
            stringArray2[1] = "</em>";
        } else if (this.inMultiLineComment) {
            String[] stringArray3 = new String[2];
            stringArray3[0] = COMMENT_START;
            stringArray = stringArray3;
            stringArray3[1] = "</em>";
        } else {
            stringArray = tags = null;
        }
        if (tags == null) {
            return this.inlineCommentFilter(line);
        }
        int index = line.indexOf("*/");
        String comment = this.uriFilter(index < 0 ? line : line.substring(0, index));
        if (index >= 0) {
            this.inJavadocComment = false;
            this.inMultiLineComment = false;
        }
        StringBuilder buf = new StringBuilder(tags[0]).append(comment);
        if (index >= 0) {
            buf.append("*/");
        }
        buf.append(tags[1]);
        if (index >= 0 && line.length() > index + 2) {
            buf.append(this.inlineCommentFilter(line.substring(index + 2)));
        }
        return buf.toString();
    }

    private String inlineCommentFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        int index = line.indexOf("//");
        if (index >= 0 && !this.isInsideString(line, index)) {
            return new StringBuffer(this.beginMultiLineCommentFilter(line.substring(0, index))).append(COMMENT_START).append(line.substring(index)).append("</em>").toString();
        }
        return this.beginMultiLineCommentFilter(line);
    }

    private String beginMultiLineCommentFilter(String line) {
        if (line == null || line.equals("")) {
            return "";
        }
        int index = line.indexOf("/*");
        if (index > -1 && !this.isInsideString(line, index)) {
            String fromIndex = line.substring(index);
            if (fromIndex.startsWith("/**") && !fromIndex.startsWith("/**/")) {
                this.inJavadocComment = true;
            } else {
                this.inMultiLineComment = true;
            }
            return this.stringFilter(line.substring(0, index)) + this.ongoingMultiLineCommentFilter(fromIndex);
        }
        return this.stringFilter(line);
    }

    private String stringFilter(String line) {
        int tempIndex;
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (line.indexOf("\"") <= -1) {
            return this.keywordFilter(line);
        }
        int start = 0;
        int startStringIndex = -1;
        int endStringIndex = -1;
        while ((tempIndex = line.indexOf("\"")) > -1) {
            if (startStringIndex == -1) {
                startStringIndex = 0;
                buf.append(this.stringFilter(line.substring(start, tempIndex)));
                buf.append(STRING_START).append("\"");
                line = line.substring(tempIndex + 1);
                continue;
            }
            startStringIndex = -1;
            endStringIndex = tempIndex;
            buf.append(line.substring(0, endStringIndex + 1));
            buf.append(STRING_END);
            line = line.substring(endStringIndex + 1);
        }
        buf.append(this.keywordFilter(line));
        return buf.toString();
    }

    private String keywordFilter(String line) {
        String classKeyword = "class";
        if (line == null || line.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        StringBuffer temp = new StringBuffer();
        while (i < line.length()) {
            temp.setLength(0);
            char ch = line.charAt(i);
            while (i < line.length() && (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z')) {
                temp.append(ch);
                if (++i >= line.length()) continue;
                ch = line.charAt(i);
            }
            String tempString = temp.toString();
            if ("class".equals(tempString) && ch == '=') {
                ++i;
                continue;
            }
            if (this.reservedWords.containsKey(tempString)) {
                StringBuffer newLine = new StringBuffer(line.substring(0, i - tempString.length()));
                newLine.append(RESERVED_WORD_START);
                newLine.append(tempString);
                newLine.append(RESERVED_WORD_END);
                newLine.append(line.substring(i));
                line = newLine.toString();
                i += RESERVED_WORD_START.length() + RESERVED_WORD_END.length();
                continue;
            }
            ++i;
        }
        buf.append(line);
        return this.uriFilter(buf.toString());
    }

    private String replace(String line, String oldString, String newString) {
        int i = 0;
        while ((i = line.indexOf(oldString, i)) >= 0) {
            line = new StringBuffer().append(line.substring(0, i)).append(newString).append(line.substring(i + oldString.length())).toString();
            i += newString.length();
        }
        return line;
    }

    private boolean isInsideString(String line, int position) {
        int index;
        if (line.indexOf(34) < 0) {
            return false;
        }
        String left = line.substring(0, position);
        String right = line.substring(position);
        int leftCount = 0;
        int rightCount = 0;
        while ((index = left.indexOf(34)) > -1) {
            ++leftCount;
            left = left.substring(index + 1);
        }
        while ((index = right.indexOf(34)) > -1) {
            ++rightCount;
            right = right.substring(index + 1);
        }
        return rightCount % 2 != 0 && leftCount % 2 != 0;
    }

    private void loadHash() {
        this.reservedWords.put("abstract", "abstract");
        this.reservedWords.put("do", "do");
        this.reservedWords.put("inner", "inner");
        this.reservedWords.put("public", "public");
        this.reservedWords.put("var", "var");
        this.reservedWords.put("boolean", "boolean");
        this.reservedWords.put("continue", "continue");
        this.reservedWords.put("int", "int");
        this.reservedWords.put("return", "return");
        this.reservedWords.put("void", "void");
        this.reservedWords.put("break", "break");
        this.reservedWords.put("else", "else");
        this.reservedWords.put("interface", "interface");
        this.reservedWords.put("short", "short");
        this.reservedWords.put("volatile", "volatile");
        this.reservedWords.put("byvalue", "byvalue");
        this.reservedWords.put("extends", "extends");
        this.reservedWords.put("long", "long");
        this.reservedWords.put("static", "static");
        this.reservedWords.put("while", "while");
        this.reservedWords.put("case", "case");
        this.reservedWords.put("final", "final");
        this.reservedWords.put("native", "native");
        this.reservedWords.put("super", "super");
        this.reservedWords.put("transient", "transient");
        this.reservedWords.put("cast", "cast");
        this.reservedWords.put("float", "float");
        this.reservedWords.put("new", "new");
        this.reservedWords.put("rest", "rest");
        this.reservedWords.put("catch", "catch");
        this.reservedWords.put("for", "for");
        this.reservedWords.put("null", "null");
        this.reservedWords.put("synchronized", "synchronized");
        this.reservedWords.put("char", "char");
        this.reservedWords.put("finally", "finally");
        this.reservedWords.put("operator", "operator");
        this.reservedWords.put("this", "this");
        this.reservedWords.put("class", "class");
        this.reservedWords.put("generic", "generic");
        this.reservedWords.put("outer", "outer");
        this.reservedWords.put("switch", "switch");
        this.reservedWords.put("const", "const");
        this.reservedWords.put("goto", "goto");
        this.reservedWords.put("package", "package");
        this.reservedWords.put("throw", "throw");
        this.reservedWords.put("double", "double");
        this.reservedWords.put("if", "if");
        this.reservedWords.put("private", "private");
        this.reservedWords.put("true", "true");
        this.reservedWords.put("default", "default");
        this.reservedWords.put("import", "import");
        this.reservedWords.put("protected", "protected");
        this.reservedWords.put("try", "try");
        this.reservedWords.put("throws", "throws");
        this.reservedWords.put("implements", "implements");
    }

    final void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    final void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    private String getFileOverview() {
        StringBuffer overview = new StringBuffer();
        if (this.javadocLinkDir != null) {
            overview.append("<div id=\"overview\">");
            StringBuffer javadocURI = new StringBuffer().append(this.javadocLinkDir);
            try {
                JavaFile jf = this.fileManager.getFile(this.getCurrentFilename());
                javadocURI.append(StringUtils.replace((String)jf.getPackageType().getName(), (String)".", (String)"/"));
                javadocURI.append("/");
                if (jf.getClassType() == null || jf.getClassType().getFilename() == null) {
                    return "";
                }
                javadocURI.append(jf.getClassType().getFilename());
                javadocURI.append(".html");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String javadocHREF = "<a href=\"" + javadocURI + "\">View Javadoc</a>";
            overview.append(javadocHREF);
            overview.append("</div>");
        }
        return overview.toString();
    }

    private String getLineWidth(int linenumber) {
        if (linenumber < 10) {
            return "   ";
        }
        if (linenumber < 100) {
            return "  ";
        }
        return " ";
    }

    private String jxrFilter(String line) {
        JavaFile jf = null;
        try {
            if (this.getCurrentFilename() == null) {
                return line;
            }
            jf = this.fileManager.getFile(this.getCurrentFilename());
        }
        catch (IOException e) {
            e.printStackTrace();
            return line;
        }
        Vector<String> v = new Vector<String>();
        ImportType[] imports = jf.getImportTypes();
        for (int j = 0; j < imports.length; ++j) {
            v.addElement(imports[j].getPackage());
        }
        v.addElement(jf.getPackageType().getName());
        Object[] packages = new String[v.size()];
        v.copyInto(packages);
        StringEntry[] words = SimpleWordTokenizer.tokenize(line);
        for (int i = 0; i < words.length; ++i) {
            StringEntry word = words[i];
            for (int j = 0; j < packages.length; ++j) {
                PackageType currentImport = this.packageManager.getPackageType((String)packages[j]);
                if (currentImport == null) continue;
                String wordName = word.toString();
                if (wordName.indexOf(".") != -1) {
                    ClassType ct;
                    String fqpnPackage = null;
                    String fqpnClass = null;
                    fqpnPackage = wordName.substring(0, wordName.lastIndexOf("."));
                    fqpnClass = wordName.substring(wordName.lastIndexOf(".") + 1, wordName.length());
                    PackageType pt = this.packageManager.getPackageType(fqpnPackage);
                    if (pt != null && (ct = pt.getClassType(fqpnClass)) != null) {
                        line = this.xrLine(line, pt.getName(), ct);
                    }
                    if (!fqpnPackage.equals(currentImport.getName()) || currentImport.getClassType(fqpnClass) == null) continue;
                    line = this.xrLine(line, (String)packages[j], currentImport.getClassType(fqpnClass));
                    continue;
                }
                if (currentImport.getClassType(wordName) == null) continue;
                line = this.xrLine(line, (String)packages[j], currentImport.getClassType(wordName));
            }
        }
        return this.importFilter(line);
    }

    private String getHREF(String dest, ClassType jc) {
        StringBuffer href = new StringBuffer();
        href.append(this.getPackageRoot());
        dest = StringUtils.replace((String)dest, (String)".*", (String)"");
        dest = StringUtils.replace((String)dest, (String)".", (String)"/");
        href.append(dest);
        if (jc != null) {
            href.append("/");
            href.append(jc.getFilename());
            href.append(".html");
        }
        return href.toString();
    }

    private String getHREF(String dest) {
        return this.getHREF(dest, null);
    }

    private int getPackageCount(String packageName) {
        if (packageName == null) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = packageName.indexOf(46, index)) != -1) {
            ++index;
            ++count;
        }
        return ++count;
    }

    private String importFilter(String line) {
        int start = -1;
        boolean isPackage = line.trim().startsWith("package ");
        boolean isImport = line.trim().startsWith("import ");
        if (isImport || isPackage) {
            start = line.trim().indexOf(" ");
        }
        if (start != -1) {
            int b;
            String packageLine;
            int a;
            String pkg = line.substring(start, line.length()).trim();
            String classname = null;
            if (pkg.indexOf(".*") != -1) {
                pkg = StringUtils.replace((String)pkg, (String)".*", (String)"");
            } else if (!isPackage && (a = (packageLine = pkg.toString()).lastIndexOf(".") + 1) > (b = packageLine.length() - 1) + 1) {
                classname = packageLine.substring(packageLine.lastIndexOf(".") + 1, packageLine.length() - 1);
                int end = pkg.lastIndexOf(".");
                if (end == -1) {
                    end = pkg.length() - 1;
                }
                pkg = pkg.substring(0, end);
            }
            pkg = StringUtils.replace((String)pkg, (String)";", (String)"");
            String pkgHREF = this.getHREF(pkg);
            if (this.packageManager.getPackageType(pkg) != null || isPackage) {
                if (classname != null) {
                    line = StringUtils.replace((String)line, (String)classname, (String)("<a href=\"" + pkgHREF + "/" + classname + ".html" + "\">" + classname + "</a>"));
                }
                line = StringUtils.replace((String)line, (String)pkg, (String)("<a href=\"" + pkgHREF + "/" + "package-summary.html" + "\">" + pkg + "</a>"));
            }
        }
        return line;
    }

    private boolean isInvalidURICharacter(char c) {
        for (int i = 0; i < VALID_URI_CHARS.length; ++i) {
            if (VALID_URI_CHARS[i] != c) continue;
            return false;
        }
        return true;
    }
}

