/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="mailing-lists")
public class MailingListsReport
extends AbstractProjectInfoReport {
    @Override
    public boolean canGenerateReport() {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getModel().getMailingLists());
        }
        return result;
    }

    public void executeReport(Locale locale) {
        MailingListsRenderer r = new MailingListsRenderer(this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale);
        r.render();
    }

    public String getOutputName() {
        return "mailing-lists";
    }

    @Override
    protected String getI18Nsection() {
        return "mailing-lists";
    }

    protected static class MailingListsRenderer
    extends AbstractProjectInfoRenderer {
        private final Model model;

        MailingListsRenderer(Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
        }

        @Override
        protected String getI18Nsection() {
            return "mailing-lists";
        }

        public void renderBody() {
            List mailingLists = this.model.getMailingLists();
            if (mailingLists == null || mailingLists.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            boolean otherArchives = false;
            for (MailingList m : mailingLists) {
                if (m.getOtherArchives() == null || m.getOtherArchives().isEmpty()) continue;
                otherArchives = true;
            }
            String name = this.getI18nString("column.name");
            String subscribe = this.getI18nString("column.subscribe");
            String unsubscribe = this.getI18nString("column.unsubscribe");
            String post = this.getI18nString("column.post");
            String archive = this.getI18nString("column.archive");
            String archivesOther = this.getI18nString("column.otherArchives");
            if (otherArchives) {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive, archivesOther});
            } else {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive});
            }
            for (MailingList mailingList : this.model.getMailingLists()) {
                ArrayList<String> textRow = new ArrayList<String>();
                textRow.add(mailingList.getName());
                textRow.add(MailingListsRenderer.createLinkPatternedText((String)subscribe, (String)mailingList.getSubscribe()));
                textRow.add(MailingListsRenderer.createLinkPatternedText((String)unsubscribe, (String)mailingList.getUnsubscribe()));
                if (mailingList.getPost() != null && mailingList.getPost().length() > 0) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)post, (String)mailingList.getPost()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getArchive() != null && mailingList.getArchive().length() > 0) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(mailingList.getArchive()), (String)mailingList.getArchive()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getOtherArchives() != null && !mailingList.getOtherArchives().isEmpty()) {
                    Iterator it = mailingList.getOtherArchives().iterator();
                    String otherArchive = (String)it.next();
                    textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(otherArchive), (String)otherArchive));
                    this.tableRow(textRow.toArray(new String[textRow.size()]));
                    while (it.hasNext()) {
                        otherArchive = (String)it.next();
                        textRow = new ArrayList();
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(MailingListsRenderer.createLinkPatternedText((String)MailingListsRenderer.getArchiveServer(otherArchive), (String)otherArchive));
                        this.tableRow(textRow.toArray(new String[textRow.size()]));
                    }
                    continue;
                }
                if (otherArchives) {
                    textRow.add(null);
                }
                this.tableRow(textRow.toArray(new String[textRow.size()]));
            }
            this.endTable();
            this.endSection();
        }

        private static String getArchiveServer(String uri) {
            if (StringUtils.isEmpty((String)uri)) {
                return "???UNKNOWN???";
            }
            int at = uri.indexOf("//");
            int fromIndex = at >= 0 ? (uri.lastIndexOf(47, at - 1) >= 0 ? 0 : at + 2) : 0;
            int from = uri.indexOf(47, fromIndex);
            if (from == -1) {
                return uri.substring(at + 2);
            }
            return uri.substring(at + 2, from);
        }
    }
}

