/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.unedit;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.perforce.command.AbstractPerforceConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerforceUnEditConsumer
extends AbstractPerforceConsumer
implements StreamConsumer {
    private static final Pattern REVISION_PATTERN = Pattern.compile("^([^#]+)#\\d+ - (.*)");
    private static final int STATE_NORMAL = 1;
    private static final int STATE_ERROR = 2;
    private int currentState = 1;
    private List<ScmFile> edits = new ArrayList<ScmFile>();

    public List<ScmFile> getEdits() {
        return this.edits;
    }

    public void consumeLine(String line) {
        Matcher matcher = REVISION_PATTERN.matcher(line);
        if (this.currentState != 2 && matcher.matches()) {
            this.edits.add(new ScmFile(matcher.group(1), ScmFileStatus.UNKNOWN));
            return;
        }
        this.error(line);
    }

    private void error(String line) {
        this.currentState = 2;
        this.output.println(line);
    }

    public boolean isSuccess() {
        return this.currentState == 1;
    }
}

