/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.InternalUtils;
import org.checkerframework.javacutil.TreeUtils;

public class LocalVariableNode
extends Node {
    protected Tree tree;
    protected Node receiver;

    public LocalVariableNode(Tree t) {
        super(InternalUtils.typeOf((Tree)t));
        assert (t != null);
        assert (t instanceof IdentifierTree || t instanceof VariableTree);
        this.tree = t;
        this.receiver = null;
    }

    public LocalVariableNode(Tree t, Node receiver) {
        this(t);
        this.receiver = receiver;
    }

    public Element getElement() {
        Element el;
        if (this.tree instanceof IdentifierTree) {
            el = TreeUtils.elementFromUse((ExpressionTree)((IdentifierTree)this.tree));
        } else {
            assert (this.tree instanceof VariableTree);
            el = TreeUtils.elementFromDeclaration((VariableTree)((VariableTree)this.tree));
        }
        return el;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    public String getName() {
        if (this.tree instanceof IdentifierTree) {
            return ((IdentifierTree)this.tree).getName().toString();
        }
        return ((VariableTree)this.tree).getName().toString();
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitLocalVariable(this, p);
    }

    public String toString() {
        return this.getName().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LocalVariableNode)) {
            return false;
        }
        LocalVariableNode other = (LocalVariableNode)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getName());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.emptyList();
    }
}

