/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.parsing;

import org.apache.commons.lang.StringUtils;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.parsing.NamespaceHandling;
import org.exolab.castor.xml.util.AttributeSetImpl;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeSetBuilder {
    private static final String XML_PREFIX = "xml";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final int XMLNS_PREFIX_LENGTH = "xmlns:".length();
    private NamespaceHandling _namespaceHandling = null;

    public AttributeSetBuilder(NamespaceHandling namespaceHandling) {
        this._namespaceHandling = namespaceHandling;
    }

    private AttributeSetImpl prepareAttributeSetImpl(Attributes atts) {
        if (atts != null) {
            return new AttributeSetImpl(atts.getLength());
        }
        return new AttributeSetImpl();
    }

    public AttributeSet getAttributeSet(Attributes atts) throws SAXException {
        AttributeSetImpl attributeSet = this.prepareAttributeSetImpl(atts);
        return this.processAttributes(atts, attributeSet);
    }

    private AttributeSet processAttributes(Attributes atts, AttributeSetImpl attributeSet) {
        String attName;
        int i;
        if (atts == null || atts.getLength() == 0) {
            return attributeSet;
        }
        boolean hasQNameAtts = false;
        for (i = 0; i < atts.getLength(); ++i) {
            attName = atts.getQName(i);
            if (StringUtils.isNotEmpty((String)attName)) {
                if (attName.equals(XMLNS) || attName.startsWith(XMLNS_PREFIX)) continue;
                if (attName.indexOf(58) < 0) {
                    attributeSet.setAttribute(attName, atts.getValue(i), atts.getURI(i));
                    continue;
                }
                hasQNameAtts = true;
                continue;
            }
            attName = atts.getLocalName(i);
            if (XMLNS.equals(attName)) continue;
            attributeSet.setAttribute(attName, atts.getValue(i), atts.getURI(i));
        }
        if (!hasQNameAtts) {
            return attributeSet;
        }
        for (i = 0; i < atts.getLength(); ++i) {
            int idx;
            attName = atts.getQName(i);
            if (!StringUtils.isNotEmpty((String)attName) || attName.equals(XMLNS) || attName.startsWith(XMLNS_PREFIX) || (idx = attName.indexOf(58)) < 0) continue;
            String prefix = attName.substring(0, idx);
            attName = attName.substring(idx + 1);
            String nsURI = atts.getURI(i);
            if (StringUtils.isEmpty((String)nsURI)) {
                nsURI = this._namespaceHandling.getNamespaceURI(prefix);
            }
            attributeSet.setAttribute(attName, atts.getValue(i), nsURI);
        }
        return attributeSet;
    }

    public AttributeSet getAttributeSet(AttributeList atts) throws SAXException {
        AttributeSetImpl attributeSet = this.prepareAttributeSetImpl(atts);
        return this.processAttributeList(atts, attributeSet);
    }

    private AttributeSet processAttributeList(AttributeList atts, AttributeSetImpl attributeSet) throws SAXException {
        int i;
        if (atts == null || atts.getLength() == 0) {
            return attributeSet;
        }
        int attCount = 0;
        boolean[] validAtts = new boolean[atts.getLength()];
        for (i = 0; i < validAtts.length; ++i) {
            String attName = atts.getName(i);
            if (attName.equals(XMLNS)) {
                this._namespaceHandling.addDefaultNamespace(atts.getValue(i));
                continue;
            }
            if (attName.startsWith(XMLNS_PREFIX)) {
                String prefix = attName.substring(XMLNS_PREFIX_LENGTH);
                this._namespaceHandling.addNamespace(prefix, atts.getValue(i));
                continue;
            }
            validAtts[i] = true;
            ++attCount;
        }
        for (i = 0; i < validAtts.length; ++i) {
            String prefix;
            if (!validAtts[i]) continue;
            String namespace = null;
            String attName = atts.getName(i);
            int idx = attName.indexOf(58);
            if (idx > 0 && !(prefix = attName.substring(0, idx)).equals(XML_PREFIX)) {
                attName = attName.substring(idx + 1);
                namespace = this._namespaceHandling.getNamespaceURI(prefix);
                if (namespace == null) {
                    String error = "The namespace associated with the prefix '" + prefix + "' could not be resolved.";
                    throw new SAXException(error);
                }
            }
            attributeSet.setAttribute(attName, atts.getValue(i), namespace);
        }
        return attributeSet;
    }

    private AttributeSetImpl prepareAttributeSetImpl(AttributeList atts) {
        if (atts == null) {
            return new AttributeSetImpl();
        }
        return new AttributeSetImpl(atts.getLength());
    }
}

