/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.extraenforcer.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

abstract class AbstractResolveDependencies
extends AbstractEnforcerRule {
    private List<String> ignoredScopes = Collections.emptyList();
    private List<String> scopes = Collections.emptyList();
    private boolean ignoreOptionals = false;
    private boolean searchTransitive = true;
    private final MavenSession session;
    private final RepositorySystem repositorySystem;

    protected AbstractResolveDependencies(MavenSession session, RepositorySystem repositorySystem) {
        this.session = session;
        this.repositorySystem = repositorySystem;
    }

    public void execute() throws EnforcerRuleException {
        this.handleArtifacts(this.getDependenciesToCheck());
    }

    protected abstract void handleArtifacts(Set<org.apache.maven.artifact.Artifact> var1) throws EnforcerRuleException;

    private Set<org.apache.maven.artifact.Artifact> getDependenciesToCheck() throws EnforcerRuleException {
        Set<org.apache.maven.artifact.Artifact> artifacts = null;
        try {
            Collection<DependencyNode> dependencies = this.collectProjectDependencies();
            artifacts = this.resolveArtifacts(dependencies);
        }
        catch (DependencyCollectionException | ArtifactResolutionException e) {
            throw new EnforcerRuleError(e.getMessage(), e);
        }
        return artifacts;
    }

    private Collection<DependencyNode> collectProjectDependencies() throws DependencyCollectionException {
        ArtifactTypeRegistry artifactTypeRegistry = this.session.getRepositorySession().getArtifactTypeRegistry();
        DependencyFilter optionalFilter = this.createOptionalFilter();
        DependencyFilter scopeFilter = this.createScopeDependencyFilter();
        final DependencyFilter dependencyFilter = AndDependencyFilter.newInstance((DependencyFilter)optionalFilter, (DependencyFilter)scopeFilter);
        List dependencies = this.session.getCurrentProject().getDependencies().stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).filter(d -> dependencyFilter == null || dependencyFilter.accept((DependencyNode)new DefaultDependencyNode(d), Collections.emptyList())).collect(Collectors.toList());
        List managedDependencies = Optional.ofNullable(this.session.getCurrentProject().getDependencyManagement()).map(DependencyManagement::getDependencies).map(list -> list.stream().map(d -> RepositoryUtils.toDependency((Dependency)d, (ArtifactTypeRegistry)artifactTypeRegistry)).collect(Collectors.toList())).orElse(null);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setManagedDependencies(managedDependencies);
        collectRequest.setRepositories(this.session.getCurrentProject().getRemoteProjectRepositories());
        collectRequest.setDependencies(dependencies);
        CollectResult collectResult = this.repositorySystem.collectDependencies(this.session.getRepositorySession(), collectRequest);
        final HashSet<DependencyNode> collectedDependencyNodes = new HashSet<DependencyNode>();
        collectResult.getRoot().accept(new DependencyVisitor(){
            int depth;

            public boolean visitEnter(DependencyNode node) {
                if ((dependencyFilter == null || dependencyFilter.accept(node, Collections.emptyList())) && node.getArtifact() != null) {
                    collectedDependencyNodes.add(node);
                }
                ++this.depth;
                return AbstractResolveDependencies.this.searchTransitive || this.depth <= 1;
            }

            public boolean visitLeave(DependencyNode node) {
                --this.depth;
                return true;
            }
        });
        return collectedDependencyNodes;
    }

    private DependencyFilter createOptionalFilter() {
        if (!this.ignoreOptionals) {
            return null;
        }
        return (node, parents) -> {
            if (node.getDependency() != null && node.getDependency().isOptional()) {
                this.getLog().debug(() -> "Skipping " + node + " due to skip optional");
                return false;
            }
            return true;
        };
    }

    private DependencyFilter createScopeDependencyFilter() {
        if (this.scopes.isEmpty() && this.ignoredScopes.isEmpty()) {
            return null;
        }
        ScopeDependencyFilter scopeDependencyFilter = new ScopeDependencyFilter(this.scopes, this.ignoredScopes);
        return (node, parents) -> {
            if (!scopeDependencyFilter.accept(node, parents)) {
                this.getLog().debug(() -> "Skipping " + node + " due to scope");
                return false;
            }
            return true;
        };
    }

    private Set<org.apache.maven.artifact.Artifact> resolveArtifacts(Collection<DependencyNode> dependencies) throws ArtifactResolutionException {
        List requestArtifacts = dependencies.stream().map(d -> new ArtifactRequest().setDependencyNode(d).setRepositories(this.session.getCurrentProject().getRemoteProjectRepositories())).collect(Collectors.toList());
        List artifactResult = this.repositorySystem.resolveArtifacts(this.session.getRepositorySession(), requestArtifacts);
        return artifactResult.stream().map(result -> result.getRequest().getDependencyNode().getDependency().setArtifact(result.getArtifact())).map(dependency -> {
            org.apache.maven.artifact.Artifact artifact = RepositoryUtils.toArtifact((Artifact)dependency.getArtifact());
            artifact.setScope(dependency.getScope());
            if (dependency.getOptional() != null) {
                artifact.setOptional(dependency.getOptional().booleanValue());
            }
            return artifact;
        }).collect(Collectors.toSet());
    }

    protected static String asRegex(String wildcard) {
        StringBuilder result = new StringBuilder(wildcard.length());
        result.append('^');
        block5: for (int index = 0; index < wildcard.length(); ++index) {
            char character = wildcard.charAt(index);
            switch (character) {
                case '*': {
                    result.append(".*");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append("\\");
                }
                default: {
                    result.append(character);
                }
            }
        }
        result.append("(\\.class)?");
        result.append('$');
        return result.toString();
    }

    protected class IgnorableDependency {
        public Pattern groupId;
        public Pattern artifactId;
        public Pattern classifier;
        public Pattern type;
        public List<Pattern> ignores = new ArrayList<Pattern>();

        protected IgnorableDependency() {
        }

        public void applyIgnoreClasses(String[] ignores, boolean indent) {
            String prefix = indent ? "  " : "";
            for (String ignore : ignores) {
                String pattern = AbstractResolveDependencies.asRegex(ignore.replace('.', '/'));
                AbstractResolveDependencies.this.getLog().debug(() -> prefix + "Ignore: " + ignore + " maps to regex " + pattern);
                this.ignores.add(Pattern.compile(pattern));
            }
        }

        public boolean matchesArtifact(org.apache.maven.artifact.Artifact dup) {
            return !(this.artifactId != null && !this.artifactId.matcher(dup.getArtifactId()).matches() || this.groupId != null && !this.groupId.matcher(dup.getGroupId()).matches() || this.classifier != null && !this.classifier.matcher(dup.getClassifier()).matches() || this.type != null && !this.type.matcher(dup.getType()).matches());
        }

        public boolean matches(String className) {
            for (Pattern p : this.ignores) {
                if (!p.matcher(className).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

