/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.recording.DefaultDependencyChangeRecord;
import org.codehaus.mojo.versions.recording.DefaultPropertyChangeRecord;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.eclipse.aether.RepositorySystem;

public abstract class UpdatePropertiesMojoBase
extends AbstractVersionsDependencyUpdaterMojo {
    @Parameter(property="autoLinkItems", defaultValue="true")
    protected boolean autoLinkItems;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates;
    @Parameter(property="includeParent", defaultValue="true")
    protected boolean includeParent = true;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    @Parameter(property="processDependencies", defaultValue="true")
    private boolean processDependencies = true;
    @Parameter(property="processDependencyManagement", defaultValue="true")
    private boolean processDependencyManagement = true;
    @Parameter(property="processParent", defaultValue="false")
    private boolean processParent = false;

    public UpdatePropertiesMojoBase(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    protected void update(MutableXMLStreamReader pom, Map<Property, PropertyVersions> propertyVersions) throws XMLStreamException {
        for (Map.Entry<Property, PropertyVersions> entry : propertyVersions.entrySet()) {
            Optional<Object> unchangedSegment;
            Property property = entry.getKey();
            PropertyVersions version = entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            boolean canUpdateProperty = true;
            for (ArtifactAssociation association : version.getAssociations()) {
                if (this.isIncluded(association.getArtifact())) continue;
                this.getLog().info((CharSequence)("Not updating the property ${" + property.getName() + "} because it is used by artifact " + association.getArtifact().toString() + " and that artifact is not included in the list of  allowed artifacts to be updated."));
                canUpdateProperty = false;
                break;
            }
            if (!canUpdateProperty) continue;
            Log log = this.getLog();
            if (log != null && !this.allowIncrementalUpdates) {
                log.info((CharSequence)"Assuming allowMinorUpdates false because allowIncrementalUpdates is false.");
            }
            if (log != null && !this.allowMinorUpdates) {
                log.info((CharSequence)"Assuming allowMajorUpdates false because allowMinorUpdates is false.");
            }
            Optional<Object> optional = this.allowMajorUpdates && this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.empty() : (this.allowMinorUpdates && this.allowIncrementalUpdates ? Optional.of(Segment.MAJOR) : (unchangedSegment = this.allowIncrementalUpdates ? Optional.of(Segment.MINOR) : Optional.of(Segment.INCREMENTAL)));
            if (log != null && log.isDebugEnabled()) {
                log.debug((CharSequence)(unchangedSegment.map(Segment::minorTo).map(Segment::toString).orElse("ALL") + " version changes allowed"));
            }
            try {
                ArtifactVersion targetVersion = this.updatePropertyToNewestVersion(pom, property, version, currentVersion, this.allowDowngrade, unchangedSegment);
                if (targetVersion == null) continue;
                this.getChangeRecorder().recordChange(DefaultPropertyChangeRecord.builder().withProperty(property.getName()).withOldValue(currentVersion).withNewValue(targetVersion.toString()).build());
                for (ArtifactAssociation association : version.getAssociations()) {
                    if (!this.isIncluded(association.getArtifact())) continue;
                    this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(DependencyChangeRecord.ChangeKind.PROPERTY).withArtifact(association.getArtifact()).withOldVersion(currentVersion).withNewVersion(targetVersion.toString()).build());
                }
            }
            catch (InvalidVersionSpecificationException | MojoExecutionException | InvalidSegmentException e) {
                this.getLog().warn((CharSequence)String.format("Skipping the processing of %s:%s due to: %s", property.getName(), property.getVersion(), e.getMessage()));
            }
        }
    }
}

