/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceIOException;
import org.codehaus.plexus.resource.loader.ResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultResourceManager
implements ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceManager.class);
    private final Map<String, ResourceLoader> resourceLoaders;
    private File outputDirectory;

    @Inject
    private DefaultResourceManager(Map<String, ResourceLoader> resourceLoaders) {
        this.resourceLoaders = resourceLoaders;
    }

    @Override
    public InputStream getResourceAsInputStream(String name) throws ResourceNotFoundException {
        PlexusResource resource = this.getResource(name);
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            throw new ResourceIOException("Failed to open resource " + resource.getName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public File getResourceAsFile(String name) throws ResourceNotFoundException, FileResourceCreationException {
        return this.getResourceAsFile(this.getResource(name));
    }

    @Override
    public File getResourceAsFile(String name, String outputPath) throws ResourceNotFoundException, FileResourceCreationException {
        if (outputPath == null) {
            return this.getResourceAsFile(name);
        }
        PlexusResource resource = this.getResource(name);
        File outputFile = this.outputDirectory != null ? new File(this.outputDirectory, outputPath) : new File(outputPath);
        this.createResourceAsFile(resource, outputFile);
        return outputFile;
    }

    @Override
    public File resolveLocation(String name, String outputPath) {
        try {
            return this.getResourceAsFile(name, outputPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public File resolveLocation(String name) {
        try {
            return this.getResourceAsFile(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void addSearchPath(String id, String path) {
        ResourceLoader loader = this.resourceLoaders.get(id);
        if (loader == null) {
            throw new IllegalArgumentException("unknown resource loader: " + id);
        }
        loader.addSearchPath(path);
    }

    @Override
    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        for (ResourceLoader resourceLoader : this.resourceLoaders.values()) {
            try {
                PlexusResource resource = resourceLoader.getResource(name);
                LOGGER.debug("The resource '{}' was found as '{}'", (Object)name, (Object)resource.getName());
                return resource;
            }
            catch (ResourceNotFoundException e) {
                LOGGER.debug("The resource '{}' was not found with resourceLoader '{}'", (Object)name, (Object)resourceLoader.getClass().getName());
            }
        }
        throw new ResourceNotFoundException(name);
    }

    @Override
    public File getResourceAsFile(PlexusResource resource) throws FileResourceCreationException {
        try {
            File f = resource.getFile();
            if (f != null) {
                return f;
            }
        }
        catch (IOException f) {
            // empty catch block
        }
        File outputFile = FileUtils.createTempFile((String)"plexus-resources", (String)"tmp", (File)this.outputDirectory);
        outputFile.deleteOnExit();
        this.createResourceAsFile(resource, outputFile);
        return outputFile;
    }

    @Override
    public void createResourceAsFile(PlexusResource resource, File outputFile) throws FileResourceCreationException {
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = resource.getInputStream();
            File dir = outputFile.getParentFile();
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new FileResourceCreationException("Failed to create directory " + dir.getPath());
            }
            os = new FileOutputStream(outputFile);
            IOUtil.copy((InputStream)is, (OutputStream)os);
            is.close();
            is = null;
            ((OutputStream)os).close();
            os = null;
        }
        catch (IOException e) {
            try {
                throw new FileResourceCreationException("Cannot create file-based resource:" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close((InputStream)is);
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)is);
        IOUtil.close((OutputStream)os);
    }
}

