/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.databene.contiperf.ExecutionLogger;
import org.databene.contiperf.util.ContiPerfUtil;

@Deprecated
public class FileExecutionLogger
implements ExecutionLogger {
    private static final String DEFAULT_FILENAME = "target/contiperf/contiperf.log";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static boolean firstCall = true;
    static AtomicLong invocationCount = new AtomicLong();

    public FileExecutionLogger() {
        this(DEFAULT_FILENAME);
    }

    public FileExecutionLogger(String fileName) {
        if (firstCall) {
            this.createSummaryFile(fileName);
            firstCall = false;
        }
    }

    @Override
    public void logInvocation(String id, int latency, long startTime) {
        invocationCount.incrementAndGet();
        System.out.println(id + ',' + latency + ',' + startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logSummary(String id, long elapsedTime, long invocationCount, long startTime) {
        FileOutputStream out = null;
        String message = id + "," + elapsedTime + ',' + invocationCount + ',' + startTime + LINE_SEPARATOR;
        try {
            out = new FileOutputStream(DEFAULT_FILENAME, true);
            ((OutputStream)out).write(message.getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ContiPerfUtil.close(out);
                throw throwable;
            }
            ContiPerfUtil.close(out);
        }
        ContiPerfUtil.close(out);
    }

    public long invocationCount() {
        return invocationCount.get();
    }

    private void createSummaryFile(String fileName) {
        File file = new File(".", fileName);
        try {
            this.ensureDirectoryExists(file.getParentFile());
            if (file.exists()) {
                file.delete();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Unable to create directory: " + file.getAbsolutePath());
        }
    }

    private void ensureDirectoryExists(File dir) throws FileNotFoundException {
        File parent = dir.getParentFile();
        if (!dir.exists()) {
            if (parent == null) {
                throw new FileNotFoundException();
            }
            this.ensureDirectoryExists(parent);
            dir.mkdir();
        }
    }
}

