/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.util.ArrayList;
import java.util.List;

public class LatencyDataSet {
    int[] xx;
    int[] yy;
    int pointCount = 0;
    List<LabelInfo> labels;
    int maxX;
    int maxY;

    public LatencyDataSet(int capacity) {
        this.xx = new int[capacity];
        this.yy = new int[capacity];
        this.labels = new ArrayList<LabelInfo>();
    }

    public void addPoint(int x, int y) {
        if (this.pointCount == 0 && y > 0 && x > 0) {
            this.addPoint(x - 1, 0);
        }
        if (this.pointCount == this.xx.length) {
            throw new RuntimeException("Capacity exceeded");
        }
        this.xx[this.pointCount] = x;
        this.yy[this.pointCount] = y;
        if (this.pointCount == 0) {
            this.maxX = x;
            this.maxY = y;
        } else {
            if (x > this.maxX) {
                this.maxX = x;
            }
            if (y > this.maxY) {
                this.maxY = y;
            }
        }
        ++this.pointCount;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int pointCount() {
        return this.pointCount;
    }

    public int getX(int i) {
        return this.xx[i];
    }

    public int getY(int i) {
        return this.yy[i];
    }

    public void scaleY(int newMax) {
        double scale = (double)newMax / (double)this.maxY;
        for (int i = 0; i < this.pointCount; ++i) {
            this.yy[i] = (int)((double)this.yy[i] * scale);
        }
    }

    public void addLabel(String text, int x) {
        this.labels.add(new LabelInfo(text, this.indexForX(x)));
    }

    private int indexForX(int x) {
        int i;
        for (i = 0; i < this.xx.length && this.xx[i] < x; ++i) {
        }
        return i;
    }

    public List<LabelInfo> getLabels() {
        return this.labels;
    }

    public LatencyDataSet reduce(int newSize) {
        int grouping = this.pointCount / newSize;
        if (grouping <= 1) {
            this.closeIfNeeded();
            return this;
        }
        LatencyDataSet result = new LatencyDataSet(newSize * 2);
        int sum = 0;
        int nonZeroIndex = -1;
        for (int i = 0; i < this.pointCount; ++i) {
            if (this.yy[i] > 0 && nonZeroIndex == -1) {
                if (i > 0) {
                    result.addPoint(this.xx[i - 1], 0);
                }
                nonZeroIndex = 0;
            }
            sum += this.yy[i];
            if (nonZeroIndex > -1 && nonZeroIndex % grouping == grouping - 1) {
                result.addPoint(this.xx[Math.max(i - grouping, 0)], sum);
                sum = 0;
            }
            if (nonZeroIndex <= -1) continue;
            ++nonZeroIndex;
        }
        this.closeIfNeeded();
        return result;
    }

    private void closeIfNeeded() {
        if (this.pointCount > 0 && this.yy[this.pointCount - 1] > 0) {
            this.addPoint(this.xx[this.pointCount - 1] + 1, 0);
        }
    }

    public class LabelInfo {
        public final String text;
        public final int index;

        public LabelInfo(String text, int index) {
            this.text = text;
            this.index = index;
        }
    }
}

