/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.spi;

import java.util.Collection;
import org.drools.core.ClassObjectFilter;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.process.CaseAssignment;
import org.kie.api.runtime.process.CaseData;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessContext
implements org.kie.api.runtime.process.ProcessContext {
    private static Logger logger = LoggerFactory.getLogger(ProcessContext.class);
    private KieRuntime kruntime;
    private ProcessInstance processInstance;
    private NodeInstance nodeInstance;

    public ProcessContext(KieRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public ProcessInstance getProcessInstance() {
        if (this.processInstance != null) {
            return this.processInstance;
        }
        if (this.nodeInstance != null) {
            return this.nodeInstance.getProcessInstance();
        }
        return null;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public NodeInstance getNodeInstance() {
        return this.nodeInstance;
    }

    public void setNodeInstance(NodeInstance nodeInstance) {
        this.nodeInstance = nodeInstance;
    }

    public Object getVariable(String variableName) {
        if (this.nodeInstance != null) {
            return this.nodeInstance.getVariable(variableName);
        }
        return ((WorkflowProcessInstance)this.getProcessInstance()).getVariable(variableName);
    }

    public void setVariable(String variableName, Object value) {
        if (this.nodeInstance != null) {
            this.nodeInstance.setVariable(variableName, value);
        } else {
            ((WorkflowProcessInstance)this.getProcessInstance()).setVariable(variableName, value);
        }
    }

    public KieRuntime getKieRuntime() {
        return this.kruntime;
    }

    public KieRuntime getKnowledgeRuntime() {
        return this.kruntime;
    }

    public Logger getLogger() {
        return logger;
    }

    public CaseData getCaseData() {
        Collection objects = this.kruntime.getObjects((ObjectFilter)new ClassObjectFilter(CaseData.class));
        if (objects.size() == 0) {
            return null;
        }
        return (CaseData)objects.iterator().next();
    }

    public CaseAssignment getCaseAssignment() {
        Collection objects = this.kruntime.getObjects((ObjectFilter)new ClassObjectFilter(CaseAssignment.class));
        if (objects.size() == 0) {
            return null;
        }
        return (CaseAssignment)objects.iterator().next();
    }
}

