/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fest.util.CollectionFilter;

public class TypeFilter<T>
implements CollectionFilter<T> {
    private final Class<T> type;

    public static <T> TypeFilter<T> byType(Class<T> type) {
        return new TypeFilter<T>(type);
    }

    TypeFilter(Class<T> type) {
        this.type = type;
    }

    @Override
    public List<T> filter(Collection<?> target) {
        if (target == null) {
            throw new IllegalArgumentException("The collection to filter should not be null");
        }
        ArrayList filtered = new ArrayList();
        for (Object o : target) {
            if (o == null || !this.type.isAssignableFrom(o.getClass())) continue;
            filtered.add(o);
        }
        return filtered;
    }
}

