/*
 * Copyright (C) Red Gate Software Ltd 2010-2024
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.flywaydb.core.internal.configuration.resolvers;

import org.flywaydb.core.ProgressLogger;
import org.flywaydb.core.api.configuration.Configuration;

import java.util.List;
import org.flywaydb.core.extensibility.ConfigurationExtension;

public interface PropertyResolverContext {
    Configuration getConfiguration();
    String getWorkingDirectory();
    String getEnvironmentName();
    String resolveValue(String input, ProgressLogger progress);
    String resolveValueOrThrow(String input, ProgressLogger progress, String propertyName);
    List<String> resolveValues(List<String> input, ProgressLogger progress);
    List<String> resolveValuesOrThrow(List<String> input, ProgressLogger progress, String propertyName);
    ConfigurationExtension getResolverConfiguration(String resolverName);

}