/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.Date;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.util.AbbreviationUtils;
import org.flywaydb.core.internal.util.ObjectUtils;

public class MigrationInfoImpl
implements MigrationInfo {
    private final ResolvedMigration resolvedMigration;
    private final AppliedMigration appliedMigration;
    private final MigrationInfoContext context;
    private final boolean outOfOrder;

    MigrationInfoImpl(ResolvedMigration resolvedMigration, AppliedMigration appliedMigration, MigrationInfoContext context, boolean outOfOrder) {
        this.resolvedMigration = resolvedMigration;
        this.appliedMigration = appliedMigration;
        this.context = context;
        this.outOfOrder = outOfOrder;
    }

    public ResolvedMigration getResolvedMigration() {
        return this.resolvedMigration;
    }

    public AppliedMigration getAppliedMigration() {
        return this.appliedMigration;
    }

    @Override
    public MigrationType getType() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getType();
        }
        return this.resolvedMigration.getType();
    }

    @Override
    public Integer getChecksum() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getChecksum();
        }
        return this.resolvedMigration.getChecksum();
    }

    @Override
    public MigrationVersion getVersion() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getVersion();
        }
        return this.resolvedMigration.getVersion();
    }

    @Override
    public String getDescription() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getDescription();
        }
        return this.resolvedMigration.getDescription();
    }

    @Override
    public String getScript() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getScript();
        }
        return this.resolvedMigration.getScript();
    }

    @Override
    public MigrationState getState() {
        if (this.appliedMigration == null) {
            if (this.resolvedMigration.getVersion() != null) {
                if (this.resolvedMigration.getVersion().compareTo(this.context.baseline) < 0) {
                    return MigrationState.BELOW_BASELINE;
                }
                if (this.context.target != null && this.resolvedMigration.getVersion().compareTo(this.context.target) > 0) {
                    return MigrationState.ABOVE_TARGET;
                }
                if (this.resolvedMigration.getVersion().compareTo(this.context.lastApplied) < 0 && !this.context.outOfOrder) {
                    return MigrationState.IGNORED;
                }
            }
            return MigrationState.PENDING;
        }
        if (MigrationType.BASELINE == this.appliedMigration.getType()) {
            return MigrationState.BASELINE;
        }
        if (this.resolvedMigration == null) {
            if (MigrationType.SCHEMA == this.appliedMigration.getType()) {
                return MigrationState.SUCCESS;
            }
            if (this.appliedMigration.getVersion() == null || this.getVersion().compareTo(this.context.lastResolved) < 0) {
                if (this.appliedMigration.isSuccess()) {
                    return MigrationState.MISSING_SUCCESS;
                }
                return MigrationState.MISSING_FAILED;
            }
            if (this.appliedMigration.isSuccess()) {
                return MigrationState.FUTURE_SUCCESS;
            }
            return MigrationState.FUTURE_FAILED;
        }
        if (!this.appliedMigration.isSuccess()) {
            return MigrationState.FAILED;
        }
        if (this.appliedMigration.getVersion() == null) {
            if (this.appliedMigration.getInstalledRank() == this.context.latestRepeatableRuns.get(this.appliedMigration.getDescription()).intValue()) {
                if (ObjectUtils.nullSafeEquals(this.appliedMigration.getChecksum(), this.resolvedMigration.getChecksum())) {
                    return MigrationState.SUCCESS;
                }
                return MigrationState.OUTDATED;
            }
            return MigrationState.SUPERSEDED;
        }
        if (this.outOfOrder) {
            return MigrationState.OUT_OF_ORDER;
        }
        return MigrationState.SUCCESS;
    }

    @Override
    public Date getInstalledOn() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledOn();
        }
        return null;
    }

    @Override
    public String getInstalledBy() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledBy();
        }
        return null;
    }

    @Override
    public Integer getInstalledRank() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledRank();
        }
        return null;
    }

    @Override
    public Integer getExecutionTime() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getExecutionTime();
        }
        return null;
    }

    public String validate() {
        MigrationState state = this.getState();
        if (MigrationState.ABOVE_TARGET.equals((Object)state)) {
            return null;
        }
        if (state.isFailed() && (!this.context.future || MigrationState.FUTURE_FAILED != state)) {
            if (this.getVersion() == null) {
                return "Detected failed repeatable migration: " + this.getDescription();
            }
            return "Detected failed migration to version " + this.getVersion() + " (" + this.getDescription() + ")";
        }
        if (this.resolvedMigration == null && this.appliedMigration.getType() != MigrationType.SCHEMA && this.appliedMigration.getType() != MigrationType.BASELINE && this.appliedMigration.getVersion() != null && (!this.context.missing || MigrationState.MISSING_SUCCESS != state && MigrationState.MISSING_FAILED != state) && (!this.context.future || MigrationState.FUTURE_SUCCESS != state && MigrationState.FUTURE_FAILED != state)) {
            return "Detected applied migration not resolved locally: " + this.getVersion();
        }
        if (!this.context.pending && MigrationState.PENDING == state || !this.context.ignored && MigrationState.IGNORED == state) {
            if (this.getVersion() != null) {
                return "Detected resolved migration not applied to database: " + this.getVersion();
            }
            return "Detected resolved repeatable migration not applied to database: " + this.getDescription();
        }
        if (!this.context.pending && MigrationState.OUTDATED == state) {
            return "Detected outdated resolved repeatable migration that should be re-applied to database: " + this.getDescription();
        }
        if (this.resolvedMigration != null && this.appliedMigration != null) {
            String migrationIdentifier;
            String string = migrationIdentifier = this.appliedMigration.getVersion() == null ? this.appliedMigration.getScript() : "version " + this.appliedMigration.getVersion();
            if (this.getVersion() == null || this.getVersion().compareTo(this.context.baseline) > 0) {
                if (this.resolvedMigration.getType() != this.appliedMigration.getType()) {
                    return this.createMismatchMessage("type", migrationIdentifier, (Object)this.appliedMigration.getType(), (Object)this.resolvedMigration.getType());
                }
                if ((this.resolvedMigration.getVersion() != null || this.context.pending && MigrationState.OUTDATED != state && MigrationState.SUPERSEDED != state) && !ObjectUtils.nullSafeEquals(this.resolvedMigration.getChecksum(), this.appliedMigration.getChecksum())) {
                    return this.createMismatchMessage("checksum", migrationIdentifier, this.appliedMigration.getChecksum(), this.resolvedMigration.getChecksum());
                }
                if (!AbbreviationUtils.abbreviateDescription(this.resolvedMigration.getDescription()).equals(this.appliedMigration.getDescription())) {
                    return this.createMismatchMessage("description", migrationIdentifier, this.appliedMigration.getDescription(), this.resolvedMigration.getDescription());
                }
            }
        }
        return null;
    }

    private String createMismatchMessage(String mismatch, String migrationIdentifier, Object applied, Object resolved) {
        return String.format("Migration " + mismatch + " mismatch for migration %s\n-> Applied to database : %s\n-> Resolved locally    : %s", migrationIdentifier, applied, resolved);
    }

    @Override
    public int compareTo(MigrationInfo o) {
        if (this.getInstalledRank() != null && o.getInstalledRank() != null) {
            return this.getInstalledRank() - o.getInstalledRank();
        }
        MigrationState state = this.getState();
        MigrationState oState = o.getState();
        if (state == MigrationState.BELOW_BASELINE && oState.isApplied()) {
            return Integer.MIN_VALUE;
        }
        if (state.isApplied() && oState == MigrationState.BELOW_BASELINE) {
            return Integer.MAX_VALUE;
        }
        if (state == MigrationState.IGNORED && oState.isApplied()) {
            if (this.getVersion() != null && o.getVersion() != null) {
                return this.getVersion().compareTo(o.getVersion());
            }
            return Integer.MIN_VALUE;
        }
        if (state.isApplied() && oState == MigrationState.IGNORED) {
            if (this.getVersion() != null && o.getVersion() != null) {
                return this.getVersion().compareTo(o.getVersion());
            }
            return Integer.MAX_VALUE;
        }
        if (this.getInstalledRank() != null) {
            return Integer.MIN_VALUE;
        }
        if (o.getInstalledRank() != null) {
            return Integer.MAX_VALUE;
        }
        if (this.getVersion() != null && o.getVersion() != null) {
            int v = this.getVersion().compareTo(o.getVersion());
            if (v != 0) {
                return v;
            }
            return 0;
        }
        if (this.getVersion() != null) {
            return Integer.MIN_VALUE;
        }
        if (o.getVersion() != null) {
            return Integer.MAX_VALUE;
        }
        return this.getDescription().compareTo(o.getDescription());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInfoImpl that = (MigrationInfoImpl)o;
        if (this.appliedMigration != null ? !this.appliedMigration.equals(that.appliedMigration) : that.appliedMigration != null) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        return !(this.resolvedMigration == null ? that.resolvedMigration != null : !this.resolvedMigration.equals(that.resolvedMigration));
    }

    public int hashCode() {
        int result = this.resolvedMigration != null ? this.resolvedMigration.hashCode() : 0;
        result = 31 * result + (this.appliedMigration != null ? this.appliedMigration.hashCode() : 0);
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

