/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.license;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.PluginMetadata;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.util.FileCopyUtils;

public class VersionPrinter {
    private static final Log LOG = LogFactory.getLog(VersionPrinter.class);
    public static final String VERSION = VersionPrinter.readVersion();
    public static Edition EDITION = Edition.COMMUNITY;

    public static String getVersion() {
        return VERSION;
    }

    public static void printVersion() {
        VersionPrinter.printVersionOnly();
    }

    public static void printVersionOnly() {
        LOG.info((Object)((Object)EDITION) + " " + VERSION + " by Redgate");
        VersionPrinter.printExtensionVersions();
    }

    private static void printExtensionVersions() {
        for (PluginMetadata plugin : PluginRegister.getPlugins(PluginMetadata.class)) {
            LOG.debug(">\t" + plugin.getDescription());
        }
    }

    private static String readVersion() {
        try {
            return FileCopyUtils.copyToString(VersionPrinter.class.getClassLoader().getResourceAsStream("org/flywaydb/core/internal/version.txt"), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to read Flyway version: " + e.getMessage(), e);
        }
    }

    private VersionPrinter() {
    }
}

