/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.saphana;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.saphana.SAPHANADatabase;
import org.flywaydb.core.internal.database.saphana.SAPHANASchema;
import org.flywaydb.core.internal.exception.FlywaySqlException;

public class SAPHANAConnection
extends org.flywaydb.core.internal.database.base.Connection<SAPHANADatabase> {
    private final boolean isCloud;

    SAPHANAConnection(SAPHANADatabase database, Connection connection) {
        super(database, connection);
        try {
            String build = this.jdbcTemplate.queryForString("SELECT VALUE FROM M_HOST_INFORMATION WHERE KEY='build_branch'", new String[0]);
            this.isCloud = build.startsWith("fa/CE");
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to determine build edition", e);
        }
    }

    public boolean isCloudConnection() {
        return this.isCloud;
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA FROM DUMMY", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((SAPHANADatabase)this.database).doQuote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new SAPHANASchema(this.jdbcTemplate, (SAPHANADatabase)this.database, name);
    }
}

