/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.ByteArrayOutputStream;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledIRBlockBody;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class MixedModeIRBlockBody
extends IRBlockBody
implements Compilable<CompiledIRBlockBody> {
    private static final Logger LOG = LoggerFactory.getLogger(MixedModeIRBlockBody.class);
    protected boolean pushScope = true;
    protected boolean reuseParentScope = false;
    private boolean displayedCFG = false;
    private InterpreterContext interpreterContext;
    private int callCount = 0;
    private volatile CompiledIRBlockBody jittedBody;

    public MixedModeIRBlockBody(IRClosure closure, Signature signature) {
        super(closure, signature);
        if (!closure.getManager().getInstanceConfig().isJitEnabled()) {
            this.setCallCount(-1);
        }
    }

    @Override
    public void setEvalType(EvalType evalType) {
        super.setEvalType(evalType);
        if (this.jittedBody != null) {
            this.jittedBody.setEvalType(evalType);
        }
    }

    @Override
    public boolean canCallDirect() {
        return this.jittedBody != null || this.interpreterContext != null && this.interpreterContext.hasExplicitCallProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCallCount(int callCount) {
        MixedModeIRBlockBody mixedModeIRBlockBody = this;
        synchronized (mixedModeIRBlockBody) {
            this.callCount = callCount;
        }
    }

    @Override
    public void completeBuild(CompiledIRBlockBody blockBody) {
        this.setCallCount(-1);
        blockBody.evalType = this.evalType;
        this.jittedBody = blockBody;
    }

    @Override
    public IRScope getIRScope() {
        return this.closure;
    }

    public BlockBody getJittedBody() {
        return this.jittedBody;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.closure.getArgumentDescriptors();
    }

    @Override
    public InterpreterContext ensureInstrsReady() {
        if (IRRuntimeHelpers.isDebug() && !this.displayedCFG) {
            LOG.info("Executing '" + this.closure + "' (pushScope=" + this.pushScope + ", reuseParentScope=" + this.reuseParentScope, new Object[0]);
            LOG.info(this.closure.debugOutput(), new Object[0]);
            this.displayedCFG = true;
        }
        if (this.interpreterContext == null) {
            if (IRRuntimeHelpers.shouldPrintIR(this.closure.getStaticScope().getModule().getRuntime())) {
                ByteArrayOutputStream baos = IRDumper.printIR(this.closure, false);
                LOG.info("Printing simple IR for " + this.closure.getId() + ":\n" + new String(baos.toByteArray()), new Object[0]);
            }
            this.interpreterContext = this.closure.getInterpreterContext();
        }
        return this.interpreterContext;
    }

    @Override
    public String getName() {
        return this.closure.getId();
    }

    @Override
    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        assert (this.jittedBody != null) : "direct call in MixedModeIRBlockBody without jitted body";
        return this.jittedBody.callDirect(context, block, args2, blockArg);
    }

    @Override
    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        assert (this.jittedBody != null) : "direct yield in MixedModeIRBlockBody without jitted body";
        return this.jittedBody.yieldDirect(context, block, args2, self2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IRubyObject commonYieldPath(ThreadContext context, Block block, Block.Type type2, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        if (this.callCount >= 0) {
            this.promoteToFullBuild(context);
        }
        InterpreterContext ic = this.ensureInstrsReady();
        Binding binding2 = block.getBinding();
        Visibility oldVis = binding2.getFrame().getVisibility();
        Frame prevFrame = context.preYieldNoScope(binding2);
        DynamicScope actualScope = binding2.getDynamicScope();
        if (ic.pushNewDynScope()) {
            context.pushScope(block.allocScope(actualScope));
        } else if (ic.reuseParentDynScope()) {
            context.pushScope(actualScope);
        }
        self2 = IRRuntimeHelpers.updateBlockState(block, self2);
        try {
            IRubyObject iRubyObject = Interpreter.INTERPRET_BLOCK(context, block, self2, ic, args2, binding2.getMethod(), blockArg);
            return iRubyObject;
        }
        finally {
            MixedModeIRBlockBody.postYield(context, ic, binding2, oldVis, prevFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteToFullBuild(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.isBooting() && !((Boolean)Options.JIT_KERNEL.load()).booleanValue()) {
            return;
        }
        if (this.callCount < 0) {
            return;
        }
        if (this.callCount++ >= runtime2.getInstanceConfig().getJitThreshold()) {
            MixedModeIRBlockBody mixedModeIRBlockBody = this;
            synchronized (mixedModeIRBlockBody) {
                if (this.callCount >= 0) {
                    this.callCount = Integer.MIN_VALUE;
                    this.ensureInstrsReady();
                    this.closure.getNearestTopLocalVariableScope().prepareForCompilation();
                    if (!this.closure.hasExplicitCallProtocol()) {
                        if (((Boolean)Options.JIT_LOGGING.load()).booleanValue()) {
                            LOG.info("JIT failed; no protocol found in block: " + this.closure, new Object[0]);
                        }
                        return;
                    }
                    runtime2.getJITCompiler().buildThresholdReached(context, this);
                }
            }
        }
    }

    @Override
    public RubyModule getImplementationClass() {
        return this.closure.getStaticScope().getModule();
    }
}

