/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.AssertionFailureBuilder;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.util.ExceptionUtils;

class AssertTimeout {
    private AssertTimeout() {
    }

    static void assertTimeout(Duration timeout, Executable executable) {
        AssertTimeout.assertTimeout(timeout, executable, (String)null);
    }

    static void assertTimeout(Duration timeout, Executable executable, @Nullable String message) {
        AssertTimeout.assertTimeout(timeout, () -> {
            executable.execute();
            return null;
        }, message);
    }

    static void assertTimeout(Duration timeout, Executable executable, Supplier<@Nullable String> messageSupplier) {
        AssertTimeout.assertTimeout(timeout, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeout(timeout, supplier, null);
    }

    static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, @Nullable String message) {
        return AssertTimeout.assertTimeout(timeout, supplier, (Object)message);
    }

    static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, Supplier<@Nullable String> messageSupplier) {
        return AssertTimeout.assertTimeout(timeout, supplier, messageSupplier);
    }

    private static <T> T assertTimeout(Duration timeout, ThrowingSupplier<T> supplier, @Nullable Object messageOrSupplier) {
        T result;
        long timeoutInMillis = timeout.toMillis();
        long start = System.currentTimeMillis();
        try {
            result = supplier.get();
        }
        catch (Throwable ex) {
            throw ExceptionUtils.throwAsUncheckedException((Throwable)ex);
        }
        long timeElapsed = System.currentTimeMillis() - start;
        if (timeElapsed > timeoutInMillis) {
            AssertionFailureBuilder.assertionFailure().message(messageOrSupplier).reason("execution exceeded timeout of " + timeoutInMillis + " ms by " + (timeElapsed - timeoutInMillis) + " ms").buildAndThrow();
        }
        return result;
    }
}

