/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.propdev.api.attachment;

import java.util.List;


public interface NarrativeService {

    /**
     * Given a collection of narratives, each narratives that was "auto-generated" will be deleted
     * from the proposal development system of record.
     *
     * @param narratives the collection of narratives.  Cannot be null.
     * @throws IllegalArgumentException if narratives collection is null
     */
    void deleteAutoGeneratedNarratives(List<? extends NarrativeContract> narratives);

    /**
     * Checks if a narrative is "auto-generated".
     * @param narrative the narrative.  Cannot be null.
     * @return true if the narrative is "auto-generated"
     * @throws IllegalArgumentException if narrative is null
     */
    boolean isAutoGeneratedNarrative(NarrativeContract narrative);

    /**
     * This method creates a system generated narrative.  Save it to the system of record.
     * None of the parameters can be null or blank.
     * @param proposalNumber the proposal number which the narrative is associated with.  Cannot be blank.
     * @param narrativeTypeCode  the narrative type code.  Cannot be blank.
     * @param attachmentData the attachment data.  Cannot be blank (null or empty array)
     * @param attachmentName the name of the attachment.  Cannot be blank.
     * @param comments the comments on the narrative.  Cannot be blank.
     * @return the created and saved narrative.  Will not return null.
     */
    NarrativeContract createSystemGeneratedNarrative(String proposalNumber, String narrativeTypeCode, byte[] attachmentData, String attachmentName, String comments);

    /**
     * Given a collection of narratives, each narratives that was "system-generated" will be deleted
     * from the proposal development system of record.
     *
     * @param narratives the collection of narratives.  Cannot be null.
     * @throws IllegalArgumentException if narratives collection is null
     */
    void deleteSystemGeneratedNarratives(List<? extends NarrativeContract> narratives);

    /**
     * Checks if a narrative is "system-generated".
     * @param narrative the narrative.  Cannot be null.
     * @return true if the narrative is "auto-generated"
     * @throws IllegalArgumentException if narrative is null
     */
    boolean isSystemGeneratedNarrative(NarrativeContract narrative);
}
