/*-
 * #%L
 * %%
 * Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.coeus.propdev.api.s2s;

public interface UserAttachedFormService {

    /**
     * This method find a S2S User Attached Form by a proposal number and namespace.  There is supposed to be only one
     * form with the same proposal number and namespace combination.  If more that one is found the first one is
     * returned.  If no matching forms are found null is returned.
     *
     * @param proposalNumber  the proposal number.  Cannot be blank
     * @param namespace the namespace.  Cannot be blank.
     * @return a S2S User Attached Form or null.
     * @throws java.lang.IllegalArgumentException if either proposalNumber or namespace is blank.
     */
    S2sUserAttachedFormContract findFormByProposalNumberAndNamespace(String proposalNumber, String namespace);

}
