/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.cloud.s3;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.scanner.ReadOnlyLocationHandler;
import org.flywaydb.core.internal.scanner.cloud.s3.AwsS3Scanner;
import org.flywaydb.core.internal.util.FeatureDetector;

public class AwsS3LocationHandler
implements ReadOnlyLocationHandler {
    @Generated
    private static final Log LOG = LogFactory.getLog(AwsS3LocationHandler.class);
    private static final String AWS_S3_PREFIX = "s3:";

    @Override
    public boolean canHandlePrefix(String prefix) {
        return AWS_S3_PREFIX.equals(prefix);
    }

    @Override
    public Collection<LoadableResource> scanForResources(Location location, Configuration configuration) {
        FeatureDetector detector = new FeatureDetector(configuration.getClassLoader());
        if (detector.isAwsAvailable()) {
            return new AwsS3Scanner(configuration.getEncoding(), configuration.isFailOnMissingLocations()).scanForResources(location);
        }
        LOG.error("Can't read location " + String.valueOf(location) + "; AWS SDK not found");
        return Collections.emptyList();
    }

    @Override
    public boolean handlesWildcards() {
        return false;
    }

    @Override
    public String getPathSeparator() {
        return "/";
    }

    @Override
    public String normalizePath(String path) {
        return path;
    }
}

