-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -
-- Narrative Types
INSERT IGNORE INTO NARRATIVE_TYPE (NARRATIVE_TYPE_CODE,DESCRIPTION,NARRATIVE_TYPE_GROUP,ALLOW_MULTIPLE,SYSTEM_GENERATED,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES ('-12','ED_524_Budget_IndirectCostRateAgreement','P','N','N','admin',NOW(),UUID(),1);

-- Narratives
INSERT IGNORE INTO SEQ_VALID_NARR_FORMS_ID VALUES (NULL);
INSERT IGNORE INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES ((SELECT (MAX(ID))
         FROM SEQ_VALID_NARR_FORMS_ID), 'ED_524_Budget_1_5-V1.5', '-12', 'N', 'admin', NOW(), UUID());

-- Questionnaire
 UPDATE QUESTIONNAIRE set NAME='ED524 Budget V1.4 & V1.5', DESCRIPTION='The responses are used to populate the ED524 Budget V1.4 & V1.5 for submission via Grants.gov' where QUESTIONNAIRE_ID = -11;

UPDATE QUESTIONNAIRE_USAGE set QUESTIONNAIRE_LABEL = 'ED524 Budget V1.4 & V1.5 Questionnaire' where QUESTIONNAIRE_REF_ID_FK in (select questionnaire_ref_id from questionnaire where questionnaire_id = -11);

insert into SEQ_QUESTIONNAIRE_REF_ID values (NULL);
insert into s2s_form_to_questionnaire(S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((select max(id) from SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/ED_524_Budget_1_5-V1.5', 'ED_524_Budget_1_5-V1.5',
        -11, NOW(), 'admin', UUID(), 1);

-- config
INSERT INTO SEQ_S2S_FORM_CONFIG_ID VALUES (NULL);
INSERT INTO S2S_FORM_CONFIG (S2S_FORM_CONFIG_ID, FORM_NAME, ACTIVE_FLAG, INACTIVE_MESSAGE, VER_NBR, OBJ_ID, UPDATE_TIMESTAMP, UPDATE_USER)
VALUES ((SELECT MAX(id) FROM SEQ_S2S_FORM_CONFIG_ID), 'ED_524_Budget_1_5-V1.5', 'Y', 'Please be aware that Section D of the ED_524_Budget_1_5-V1.5 is not currently supported. If you require Section D to be mapped you will need to upload as user attached form.', '1', UUID(), NOW(), 'admin');

