/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import lombok.Generated;
import org.flywaydb.core.api.CoreErrorCode;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.scanner.ReadWriteLocationHandler;
import org.flywaydb.core.internal.scanner.filesystem.FileSystemScanner;

public class FilesystemLocationHandler
implements ReadWriteLocationHandler {
    private final String prefix = "filesystem:";

    @Override
    public Collection<LoadableResource> scanForResources(Location location, Configuration configuration) {
        boolean stream = configuration.isStream();
        FileSystemScanner fileSystemScanner = new FileSystemScanner(stream, configuration);
        return fileSystemScanner.scanForResources(location);
    }

    @Override
    public boolean handlesWildcards() {
        return true;
    }

    @Override
    public String getPathSeparator() {
        return File.separator;
    }

    @Override
    public String normalizePath(String path) {
        return new File(path).getPath();
    }

    @Override
    public OutputStream getOutputStream(Location fileLocation, Configuration configuration) {
        File file;
        try {
            file = new File(ConfigUtils.getFilenameWithWorkingDirectory(fileLocation.getRootPath(), configuration)).getCanonicalFile();
        }
        catch (IOException e) {
            throw new FlywayException("Unable to get canonical path for file " + fileLocation.getRootPath() + ": " + e.getMessage(), e, CoreErrorCode.ERROR);
        }
        String path = file.getAbsolutePath();
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new FlywayException("Unable to write output to " + path + " as it is a directory and not a file", CoreErrorCode.ERROR);
            }
            if (!file.canWrite()) {
                throw new FlywayException("Unable to write output to " + path + " as it is write-protected", CoreErrorCode.ERROR);
            }
        } else {
            File dir = file.getParentFile();
            if (dir != null && !dir.exists() && !dir.mkdirs()) {
                throw new FlywayException("Unable to create parent directories for output to " + path, CoreErrorCode.ERROR);
            }
        }
        try {
            return new FileOutputStream(path);
        }
        catch (FileNotFoundException e) {
            throw new FlywayException("Unable to write to " + path + e.getMessage(), e, CoreErrorCode.CONFIGURATION);
        }
    }

    @Override
    @Generated
    public String getPrefix() {
        return this.prefix;
    }
}

