-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
CREATE PROCEDURE fix_sub_award_amount_info()
BEGIN
  DECLARE MAIN_DONE INT DEFAULT FALSE;

  DECLARE V_SUBAWARD_CODE VARCHAR(20);
  DECLARE V_SEQUENCE_NUMBER DECIMAL(4, 0);
  DECLARE V_SUBAWARD_ID DECIMAL(12, 0);

  DECLARE V_SUBAWARD_AMOUNT_INFO_ID DECIMAL(12, 0);
  DECLARE V_OBLIGATED_AMOUNT DECIMAL(12, 2);
  DECLARE V_OBLIGATED_CHANGE DECIMAL(12, 2);
  DECLARE V_ANTICIPATED_AMOUNT DECIMAL(12, 2);
  DECLARE V_ANTICIPATED_CHANGE DECIMAL(12, 2);
  DECLARE V_EFFECTIVE_DATE DATE;
  DECLARE V_COMMENTS VARCHAR(300);
  DECLARE V_UPDATE_TIMESTAMP DATE;
  DECLARE V_UPDATE_USER VARCHAR(60);
  DECLARE V_FILE_NAME VARCHAR(150);
  DECLARE V_MIME_TYPE VARCHAR(100);
  DECLARE V_VER_NBR DECIMAL(8, 0);
  DECLARE V_MODIFICATION_EFFECTIVE_DATE DATE;
  DECLARE V_MODIFICATION_NUMBER VARCHAR(50);
  DECLARE V_PERFORMANCE_START_DATE DATE;
  DECLARE V_PERFORMANCE_END_DATE DATE;
  DECLARE V_FILE_DATA_ID VARCHAR(36);
  DECLARE V_MODIFICATION_TYPE_CODE VARCHAR(30);
  DECLARE V_OBLIGATED_CHANGE_DIRECT DECIMAL(12, 2);
  DECLARE V_OBLIGATED_CHANGE_INDIRECT DECIMAL(12, 2);
  DECLARE V_ANTICIPATED_CHANGE_DIRECT DECIMAL(12, 2);
  DECLARE V_ANTICIPATED_CHANGE_INDIRECT DECIMAL(12, 2);
  DECLARE V_RATE DECIMAL(5, 2);

  DECLARE COUNTER INT DEFAULT 0;

  DECLARE MAIN_CUR CURSOR FOR select subaward_code, sequence_number, subaward_id
                              from subaward
                              where subaward_sequence_status in ('ACTIVE', 'PENDING', 'ARCHIVED')
                              order by subaward_code, sequence_number;
  DECLARE CONTINUE HANDLER FOR NOT FOUND SET MAIN_DONE = TRUE;

  SET FOREIGN_KEY_CHECKS=0;

  DROP TABLE IF EXISTS subaward_amount_info_v1905_006;
  CREATE TABLE subaward_amount_info_v1905_006 AS select * from subaward_amount_info;
  DELETE FROM subaward_amount_info;

  DROP TABLE IF EXISTS subaward_ffata_repor_v1905_006;
  CREATE TABLE subaward_ffata_repor_v1905_006 AS select * from subaward_ffata_reporting;

  OPEN MAIN_CUR;

  main_loop:
    LOOP
      FETCH MAIN_CUR INTO V_SUBAWARD_CODE, V_SEQUENCE_NUMBER, V_SUBAWARD_ID;
      IF MAIN_DONE THEN
        LEAVE main_loop;
      END IF;

      TOINSERT_BLOCK:
      begin
        DECLARE TOINSERT_DONE INT DEFAULT FALSE;
        DECLARE TOINSERT_CUR CURSOR FOR select SUBAWARD_AMOUNT_INFO_ID,
                                               OBLIGATED_AMOUNT,
                                               OBLIGATED_CHANGE,
                                               ANTICIPATED_AMOUNT,
                                               ANTICIPATED_CHANGE,
                                               EFFECTIVE_DATE,
                                               COMMENTS,
                                               UPDATE_TIMESTAMP,
                                               UPDATE_USER,
                                               FILE_NAME,
                                               MIME_TYPE,
                                               VER_NBR,
                                               MODIFICATION_EFFECTIVE_DATE,
                                               MODIFICATION_NUMBER,
                                               PERFORMANCE_START_DATE,
                                               PERFORMANCE_END_DATE,
                                               FILE_DATA_ID,
                                               MODIFICATION_TYPE_CODE,
                                               OBLIGATED_CHANGE_DIRECT,
                                               OBLIGATED_CHANGE_INDIRECT,
                                               ANTICIPATED_CHANGE_DIRECT,
                                               ANTICIPATED_CHANGE_INDIRECT,
                                               RATE
                                        from subaward_amount_info_v1905_006
                                        where subaward_id in (
                                          select subaward_id
                                          from subaward
                                          where subaward_sequence_status in ('ACTIVE', 'PENDING', 'ARCHIVED')
                                            and subaward_code = V_SUBAWARD_CODE
                                            and sequence_number <= V_SEQUENCE_NUMBER)
                                        order by SUBAWARD_AMOUNT_INFO_ID;
        DECLARE CONTINUE HANDLER FOR NOT FOUND SET TOINSERT_DONE = TRUE;

        OPEN TOINSERT_CUR;

        toinsert_loop:
          LOOP
            FETCH TOINSERT_CUR INTO V_SUBAWARD_AMOUNT_INFO_ID,
              V_OBLIGATED_AMOUNT,
              V_OBLIGATED_CHANGE,
              V_ANTICIPATED_AMOUNT,
              V_ANTICIPATED_CHANGE,
              V_EFFECTIVE_DATE,
              V_COMMENTS,
              V_UPDATE_TIMESTAMP,
              V_UPDATE_USER,
              V_FILE_NAME,
              V_MIME_TYPE,
              V_VER_NBR,
              V_MODIFICATION_EFFECTIVE_DATE,
              V_MODIFICATION_NUMBER,
              V_PERFORMANCE_START_DATE,
              V_PERFORMANCE_END_DATE,
              V_FILE_DATA_ID,
              V_MODIFICATION_TYPE_CODE,
              V_OBLIGATED_CHANGE_DIRECT,
              V_OBLIGATED_CHANGE_INDIRECT,
              V_ANTICIPATED_CHANGE_DIRECT,
              V_ANTICIPATED_CHANGE_INDIRECT,
              V_RATE;

            IF TOINSERT_DONE THEN
              LEAVE toinsert_loop;
            END IF;

            INSERT INTO SUBAWARD_AMT_INFO_ID_S VALUES (NULL);

            INSERT INTO subaward_amount_info
            values ((SELECT (MAX(ID)) FROM SUBAWARD_AMT_INFO_ID_S),
                    V_SUBAWARD_ID,
                    V_OBLIGATED_AMOUNT,
                    V_OBLIGATED_CHANGE,
                    V_ANTICIPATED_AMOUNT,
                    V_ANTICIPATED_CHANGE,
                    V_EFFECTIVE_DATE,
                    V_COMMENTS,
                    V_UPDATE_TIMESTAMP,
                    V_UPDATE_USER,
                    V_FILE_NAME,
                    V_MIME_TYPE,
                    V_VER_NBR,
                    UUID(),
                    V_SEQUENCE_NUMBER,
                    V_SUBAWARD_CODE,
                    V_MODIFICATION_EFFECTIVE_DATE,
                    V_MODIFICATION_NUMBER,
                    V_PERFORMANCE_START_DATE,
                    V_PERFORMANCE_END_DATE,
                    V_FILE_DATA_ID,
                    V_MODIFICATION_TYPE_CODE,
                    V_OBLIGATED_CHANGE_DIRECT,
                    V_OBLIGATED_CHANGE_INDIRECT,
                    V_ANTICIPATED_CHANGE_DIRECT,
                    V_ANTICIPATED_CHANGE_INDIRECT,
                    V_RATE);

            UPDATE subaward_ffata_reporting SET subaward_amount_info_id = (SELECT (MAX(ID)) FROM SUBAWARD_AMT_INFO_ID_S) WHERE subaward_id = V_SUBAWARD_ID AND subaward_amount_info_id = V_SUBAWARD_AMOUNT_INFO_ID;

            IF COUNTER >= 500 THEN
                COMMIT;
                SET COUNTER = 1;
            ELSE
                SET COUNTER = COUNTER + 1;
            END IF;

          END LOOP;
      end TOINSERT_BLOCK;
    END LOOP;
    COMMIT;

  SET FOREIGN_KEY_CHECKS=0;
END
/
DELIMITER ;
CALL fix_sub_award_amount_info();

drop PROCEDURE if exists fix_sub_award_amount_info;
