/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.result;

import com.mysql.cj.Messages;
import com.mysql.cj.exceptions.DataReadException;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.WrongArgumentException;
import com.mysql.cj.result.DefaultValueFactory;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class SqlTimestampValueFactory
extends DefaultValueFactory<Timestamp> {
    private Calendar cal;

    public SqlTimestampValueFactory(Calendar calendar, TimeZone tz) {
        if (calendar != null) {
            this.cal = (Calendar)calendar.clone();
        } else {
            this.cal = Calendar.getInstance(tz, Locale.US);
            this.cal.setLenient(false);
        }
    }

    @Override
    public Timestamp createFromDate(int year, int month, int day) {
        return this.createFromTimestamp(year, month, day, 0, 0, 0, 0);
    }

    @Override
    public Timestamp createFromTime(int hours, int minutes, int seconds, int nanos) {
        if (hours < 0 || hours >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{"" + hours + ":" + minutes + ":" + seconds}));
        }
        return this.createFromTimestamp(1970, 1, 1, hours, minutes, seconds, nanos);
    }

    @Override
    public Timestamp createFromTimestamp(int year, int month, int day, int hours, int minutes, int seconds, int nanos) {
        if (year == 0 && month == 0 && day == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        Calendar calendar = this.cal;
        synchronized (calendar) {
            try {
                this.cal.set(year, month - 1, day, hours, minutes, seconds);
                Timestamp ts = new Timestamp(this.cal.getTimeInMillis());
                ts.setNanos(nanos);
                return ts;
            }
            catch (IllegalArgumentException e2) {
                throw ExceptionFactory.createException(WrongArgumentException.class, e2.getMessage(), e2);
            }
        }
    }

    @Override
    public String getTargetTypeName() {
        return Timestamp.class.getName();
    }
}

