/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.db.client;

import co.kuali.coeus.db.client.internal.CollectionUtils;
import co.kuali.coeus.db.client.internal.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.output.InfoResult;
import org.flywaydb.core.api.output.MigrateResult;
import org.flywaydb.core.api.output.OperationResultBase;

public final class FlywayClient {
    private static final Logger LOG = LogManager.getLogger(FlywayClient.class);

    private FlywayClient() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void main(String[] args) {
        try {
            FlywayClient.main();
            LOG.info("SUCCESS");
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
            System.exit(1);
        }
    }

    public static void main() {
        Boolean enabled = FlywayClient.getValueAsBoolean("KC_FLYWAY_ENABLED");
        if (enabled != null && enabled.booleanValue()) {
            String commands = FlywayClient.getValueAsString("KC_FLYWAY_COMMANDS");
            if (StringUtils.isNotBlank(commands)) {
                FlywayClient.execute(commands);
            } else {
                LOG.warn("Flyway is enabled but no flyway commands are found.");
            }
        } else {
            LOG.info("Disabled flyway");
        }
    }

    private static void execute(String commands) {
        Flyway flyway = new FluentConfiguration().envVars().load();
        Arrays.stream(commands.split(",")).map(String::trim).filter(StringUtils::isNotBlank).map(String::toLowerCase).distinct().map(command -> CollectionUtils.entry(command, FlywayClient.findMethod(flyway, command))).forEach(cmdEntry -> {
            String command = (String)cmdEntry.getKey();
            Method cmdMethod = (Method)cmdEntry.getValue();
            if (cmdMethod != null) {
                LOG.info("Executing flyway command [" + command + "]");
                try {
                    Object result = cmdMethod.invoke((Object)flyway, new Object[0]);
                    if (!LOG.isInfoEnabled()) return;
                    LOG.info("Executed flyway command [" + command + "] with result [" + FlywayClient.resultToString(result) + "]");
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.error("Failed flyway command [" + command + "]", (Throwable)e);
                    throw new RuntimeException(e);
                }
            } else {
                LOG.error("Not Found flyway command [" + command + "]");
            }
        });
    }

    private static String resultToString(Object result) {
        String flywayResult = "flyway result\n\t";
        if (result instanceof MigrationInfoService) {
            MigrationInfoService info = (MigrationInfoService)result;
            InfoResult res = info.getInfoResult();
            return "flyway result\n\t" + FlywayClient.toStr(res) + " schema version: " + res.schemaVersion + " schema name: " + res.schemaName + " all schemas empty: " + res.allSchemasEmpty + "\n pending migrations:\n" + FlywayClient.toStr(info.pending());
        }
        if (result instanceof MigrateResult) {
            MigrateResult res = (MigrateResult)result;
            return "flyway result\n\t" + FlywayClient.toStr(res) + " initial schema version: " + res.initialSchemaVersion + " target schema version: " + res.targetSchemaVersion + " schema name: " + res.schemaName + " migrations executed: " + res.migrationsExecuted;
        }
        if (result instanceof OperationResultBase) {
            return "flyway result\n\t" + FlywayClient.toStr((OperationResultBase)result) + " " + result.getClass().getName();
        }
        if (result != null) {
            return "flyway result\n\t" + result;
        }
        return "flyway result\n\t";
    }

    private static String toStr(OperationResultBase result) {
        return "flyway version: " + result.flywayVersion + " database: " + result.database + " operation: " + result.operation + " warnings: " + result.warnings;
    }

    private static String toStr(MigrationInfo[] applied) {
        return Arrays.stream(applied).map(FlywayClient::toStr).collect(Collectors.joining("\n"));
    }

    private static String toStr(MigrationInfo i) {
        return "\ttype: " + i.getType() + " checksum: " + i.getChecksum() + " version: " + i.getVersion() + " description: " + i.getDescription() + " script: " + i.getScript() + " state: " + i.getState() + " installed on: " + i.getInstalledOn() + " installed by: " + i.getInstalledBy() + " installed rank: " + i.getInstalledRank() + " execution time: " + i.getExecutionTime() + " physical location: " + i.getPhysicalLocation();
    }

    private static Method findMethod(Flyway flyway, String command) {
        try {
            return flyway.getClass().getMethod(command, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String getValueAsString(String envCfg) {
        String env = System.getenv(envCfg);
        if (StringUtils.isNotBlank(env)) {
            return env;
        }
        return null;
    }

    private static Boolean getValueAsBoolean(String envCfg) {
        String env = System.getenv(envCfg);
        if (StringUtils.isNotBlank(env)) {
            return Boolean.valueOf(env);
        }
        return null;
    }
}

