-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
--
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

DELIMITER /
CREATE PROCEDURE add_contact_usage()
BEGIN
    DECLARE MAIN_DONE INT DEFAULT FALSE;
    DECLARE V_CONTACT_TYPE_CODE VARCHAR(20);

    DECLARE MAIN_CUR CURSOR FOR select distinct contact_type_code
                                from subaward_contact
                                where contact_type_code not in
                                      (select contact_type_code from contact_usage where module_code = 4)
                                order by contact_type_code desc;
    DECLARE CONTINUE HANDLER FOR NOT FOUND SET MAIN_DONE = TRUE;

    OPEN MAIN_CUR;

    main_loop:
        LOOP
            FETCH MAIN_CUR INTO V_CONTACT_TYPE_CODE;
            IF MAIN_DONE THEN
                LEAVE main_loop;
            END IF;

            INSERT INTO seq_contact_usage_id VALUES (NULL);

            INSERT INTO contact_usage
            VALUES ((SELECT (MAX(ID)) FROM seq_contact_usage_id), V_CONTACT_TYPE_CODE, 4, NOW(), 'admin', 1, UUID());
        END LOOP;
    COMMIT;

END
/
DELIMITER ;
CALL add_contact_usage();

drop PROCEDURE if exists add_contact_usage;
