-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

-- KULRICE-9198 - krms_attr_defn_t.attr_defn_id is a varchar(255),
--                but referencing columns are a mixture of varchar(40) and varchar(255)
DELIMITER /

ALTER TABLE KRMS_TYP_ATTR_T DROP FOREIGN KEY `krms_typ_attr_fk1`
/

ALTER TABLE KRMS_ACTN_ATTR_T DROP FOREIGN KEY `krms_actn_attr_fk2`
/

ALTER TABLE KRMS_AGENDA_ATTR_T DROP FOREIGN KEY `krms_agenda_attr_fk2`
/

ALTER TABLE KRMS_TERM_RSLVR_ATTR_T DROP FOREIGN KEY krms_term_rslvr_attr_fk2
/

ALTER TABLE KRMS_RULE_ATTR_T DROP FOREIGN KEY `krms_rule_attr_fk2`
/

ALTER TABLE KRMS_CNTXT_ATTR_T DROP FOREIGN KEY `krms_cntxt_attr_fk2`
/

ALTER TABLE KRMS_NL_TMPL_ATTR_T DROP FOREIGN KEY krms_nl_tmpl_attr_fk2
/

ALTER TABLE KRMS_NL_USAGE_ATTR_T DROP FOREIGN KEY krms_nl_usage_attr_fk2
/

ALTER TABLE KRMS_TYP_ATTR_T MODIFY ATTR_DEFN_ID VARCHAR(40)
/

ALTER TABLE KRMS_ATTR_DEFN_T MODIFY ATTR_DEFN_ID VARCHAR(40)
/

ALTER TABLE KRMS_TYP_ATTR_T
  ADD CONSTRAINT KRMS_TYP_ATTR_FK1
    FOREIGN KEY (ATTR_DEFN_ID)
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID)
/

ALTER TABLE KRMS_ACTN_ATTR_T 
  ADD CONSTRAINT KRMS_ACTN_ATTR_FK2
    FOREIGN KEY (ATTR_DEFN_ID )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID)
/

ALTER TABLE KRMS_AGENDA_ATTR_T
  ADD CONSTRAINT KRMS_AGENDA_ATTR_FK2
    FOREIGN KEY (ATTR_DEFN_ID)
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID)
/

ALTER TABLE KRMS_TERM_RSLVR_ATTR_T 
  ADD CONSTRAINT KRMS_TERM_RSLVR_ATTR_FK2
    FOREIGN KEY (ATTR_DEFN_ID )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID)
/

ALTER TABLE KRMS_RULE_ATTR_T
  ADD CONSTRAINT KRMS_RULE_ATTR_FK2
    FOREIGN KEY (ATTR_DEFN_ID )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID )
/

ALTER TABLE KRMS_CNTXT_ATTR_T
  ADD CONSTRAINT KRMS_CNTXT_ATTR_FK2
    FOREIGN KEY (ATTR_DEFN_ID )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID )
/

ALTER TABLE KRMS_TERM_RSLVR_ATTR_T
  ADD CONSTRAINT KRMS_ASSET_RSLVR_ATTR_FK2
    FOREIGN KEY (ATTR_DEFN_ID )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID )
/

ALTER TABLE krms_nl_tmpl_attr_t
  ADD CONSTRAINT krms_nl_tmpl_attr_fk2
    FOREIGN KEY (attr_defn_id )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID )
/

ALTER TABLE krms_nl_usage_attr_t
  ADD CONSTRAINT krms_nl_usage_attr_fk2
    FOREIGN KEY (attr_defn_id )
    REFERENCES KRMS_ATTR_DEFN_T (ATTR_DEFN_ID )
/
    

DELIMITER ;
