-- -
-- #%L
-- %%
-- Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
-- -

delete from SUBAWARD_FORMS WHERE FORM_ID = 'FDP_NIH';

INSERT INTO SUBAWARD_FORMS(FORM_ID,DESCRIPTION,UPDATE_TIMESTAMP,UPDATE_USER,FORM,FILE_NAME,CONTENT_TYPE,VER_NBR,OBJ_ID,TEMPLATE_TYPE_CODE) values ('FDP_NIH',	'NIH Attachment',now(),'admin',
'<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:subcontract="http://subcontractFdpReports.bean.xml.utils.coeus.mit.edu/subcontract"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in"
                                   margin-right="0.2in">
                <fo:region-body margin-top="0.5in" margin-bottom="0.79in"/>
                <fo:region-before extent="0.5in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="headerall"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <fo:block/>
                        <xsl:for-each select="$XML">
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table font-family="Times New Roman" font-size="12pt" font-weight="bold" table-layout="fixed"
                                      width="100%" border="solid 1pt gray" border-spacing="-1pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block text-align="center" margin="0pt">
                                                    <fo:block>
                                                        <fo:inline>
                                                            <xsl:text>Attachment 2</xsl:text>
                                                        </fo:inline>
                                                        <fo:block/>
                                                        <fo:inline>
                                                            <xsl:text>Research Subaward Agreement</xsl:text>
                                                        </fo:inline>
                                                        <fo:block/>
                                                        <fo:inline>
                                                            <xsl:text>Prime Award Terms and Conditions</xsl:text>
                                                        </fo:inline>
                                                        <fo:block/>
                                                        <fo:inline>
                                                            <xsl:text>NIH</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table font-family="Times New Roman" table-layout="fixed" width="100%" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row font-size="12pt" font-weight="bold">
                                        <fo:table-cell padding="0" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>Agency-Specific Certifications/Assurances</xsl:text>
                                                </fo:inline>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block
                                                        margin="0pt">
                                                    <fo:block/>
                                                </fo:block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row font-size="10pt" font-weight="normal">
                                        <fo:table-cell padding="0" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text> 1.	By signing this Research Subaward Agreement Subrecipient makes the certifications and assurances specified in the Research Terms and Conditions Subchapter D found at:  </xsl:text>
                                                </fo:inline>
                                                <fo:basic-link text-decoration="underline" color="blue">
                                                    <xsl:choose>
                                                        <xsl:when
                                                                test="substring(string(&apos;nsf.gov/bfa/dias/policy/rtc/appc_june11.pdf&apos;), 1, 1) = ''#''">
                                                            <xsl:attribute name="internal-destination">
                                                                <xsl:value-of
                                                                        select="substring(string(&apos;nsf.gov/bfa/dias/policy/rtc/appc_june11.pdf&apos;), 2)"/>
                                                            </xsl:attribute>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:attribute name="external-destination">
                                                                <xsl:text>url(</xsl:text>
                                                                <xsl:call-template name="double-backslash">
                                                                    <xsl:with-param name="text">
                                                                        <xsl:value-of
                                                                                select="string(&apos;nsf.gov/bfa/dias/policy/rtc/appc_june11.pdf&apos;)"/>
                                                                    </xsl:with-param>
                                                                    <xsl:with-param name="text-length">
                                                                        <xsl:value-of
                                                                                select="string-length(string(&apos;nsf.gov/bfa/dias/policy/rtc/appc_june11.pdf&apos;))"/>
                                                                    </xsl:with-param>
                                                                </xsl:call-template>
                                                                <xsl:text>)</xsl:text>
                                                            </xsl:attribute>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                    <fo:inline>
                                                        <xsl:text>http://www.nsf.gov/bfa/dias/policy/rtc/appc_june11.pdf</xsl:text>
                                                    </fo:inline>
                                                </fo:basic-link>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:block>
                                <fo:leader leader-pattern="space"/>
                            </fo:block>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:block margin="0pt">
                                <fo:block/>
                            </fo:block>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                <fo:table-column column-width="28%"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row font-family="Times New Roman" font-size="12pt" font-weight="bold">
                                        <fo:table-cell padding="2pt" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>General terms and conditions </xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-size="10pt" font-weight="normal" padding="2pt" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>as of the effective date of this Research Subaward Agreement:</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table font-family="time" font-size="10pt" table-layout="fixed" width="100%" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell padding="2pt" display-align="center">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:list-block provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="1"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block font-family="time" font-size="10pt" font-weight="normal">
                                                                <fo:inline>
                                                                    <xsl:text>Conditions on activities and restrictions on expenditure of federal funds in appropriations acts are applicable to this subaward to the extent those restrictions are pertinent.  This includes any recent legislation noted on the NIH Award Conditions website:  </xsl:text>
                                                                    <fo:basic-link text-decoration="underline" color="blue">
                                                                        <xsl:choose>
                                                                            <xsl:when
                                                                                    test="substring(string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html&apos;), 1, 1) = ''#''">
                                                                                <xsl:attribute name="internal-destination">
                                                                                    <xsl:value-of
                                                                                            select="substring(string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html&apos;), 2)"/>
                                                                                </xsl:attribute>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:attribute name="external-destination">
                                                                                    <xsl:text>url(</xsl:text>
                                                                                    <xsl:call-template name="double-backslash">
                                                                                        <xsl:with-param name="text">
                                                                                            <xsl:value-of
                                                                                                    select="string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html&apos;)"/>
                                                                                        </xsl:with-param>
                                                                                        <xsl:with-param name="text-length">
                                                                                            <xsl:value-of
                                                                                                    select="string-length(string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html&apos;))"/>
                                                                                        </xsl:with-param>
                                                                                    </xsl:call-template>
                                                                                    <xsl:text>)</xsl:text>
                                                                                </xsl:attribute>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                        <fo:inline>
                                                                            <xsl:text>http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html</xsl:text>
                                                                        </fo:inline>
                                                                    </fo:basic-link>



                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="2"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block font-family="time" font-size="10pt" font-weight="normal">
                                                                <fo:inline>
                                                                    <xsl:text>45 CFR Part 75.</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="3"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block font-family="time" font-size="10pt" font-weight="normal">
                                                                <fo:inline>
                                                                    <xsl:text>The </xsl:text>
                                                                </fo:inline>
                                                                <fo:inline font-weight="bold">
                                                                    <xsl:text>NIH Grants Policy Statement </xsl:text>
                                                                </fo:inline>
                                                                <fo:inline>
                                                                    <xsl:text>found at </xsl:text>
                                                                </fo:inline>
                                                                <fo:basic-link text-decoration="underline" color="blue">
                                                                    <xsl:choose>
                                                                        <xsl:when
                                                                                test="substring(string(&apos;grants.nih.gov/grants/policy/policy.htm#gps&apos;), 1, 1) = ''#''">
                                                                            <xsl:attribute name="internal-destination">
                                                                                <xsl:value-of
                                                                                        select="substring(string(&apos;grants.nih.gov/grants/policy/policy.htm#gps&apos;), 2)"/>
                                                                            </xsl:attribute>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <xsl:attribute name="external-destination">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">
                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(&apos;grants.nih.gov/grants/policy/policy.htm#gps&apos;)"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(&apos;grants.nih.gov/grants/policy/policy.htm#gps&apos;))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                    <fo:inline>
                                                                        <xsl:text> http://grants.nih.gov/grants/policy/policy.htm#gps </xsl:text>
                                                                    </fo:inline>
                                                                </fo:basic-link>
                                                                <fo:inline>
                                                                    <xsl:text>, including addenda in effect as of the beginning date of the period of performance.</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="4"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block font-family="time" font-size="10pt" font-weight="normal">
                                                                <fo:inline>
                                                                    <xsl:text>Interim Research Terms and Conditions found at </xsl:text>
                                                                </fo:inline>
                                                                <fo:basic-link text-decoration="underline" color="blue">
                                                                    <xsl:choose>
                                                                        <xsl:when
                                                                                test="substring(string(&apos;http://grants.nih.gov/grants/policy/NIH%20Interim%20Grant%20General%20Conditions.pdf&apos;), 1, 1) = ''#''">
                                                                            <xsl:attribute name="internal-destination">
                                                                                <xsl:value-of
                                                                                        select="substring(string(&apos;http://grants.nih.gov/grants/policy/NIH%20Interim%20Grant%20General%20Conditions.pdf&apos;), 2)"/>
                                                                            </xsl:attribute>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <xsl:attribute name="external-destination">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">

                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(&apos;http://grants.nih.gov/grants/policy/NIH%20Interim%20Grant%20General%20Conditions.pdf&apos;)"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(&apos;http://grants.nih.gov/grants/policy/NIH%20Interim%20Grant%20General%20Conditions.pdf&apos;))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                    <fo:inline>
                                                                        <xsl:text> http://grants.nih.gov/grants/policy/NIH%20Interim%20Grant%20General%20Conditions.pdf</xsl:text>
                                                                    </fo:inline>
                                                                </fo:basic-link>
                                                                <fo:inline>
                                                                    <xsl:text> and Agency Specific Requirements found at </xsl:text>
                                                                </fo:inline>
                                                                <fo:basic-link text-decoration="underline" color="blue">
                                                                    <xsl:choose>
                                                                        <xsl:when
                                                                                test="substring(string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html &apos;), 1, 1) = ''#''">
                                                                            <xsl:attribute name="internal-destination">
                                                                                <xsl:value-of
                                                                                        select="substring(string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html &apos;), 2)"/>
                                                                            </xsl:attribute>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <xsl:attribute name="external-destination">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">
                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html &apos;)"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(&apos;http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html &apos;))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                    <fo:inline>
                                                                        <xsl:text>http://grants.nih.gov/grants/guide/notice-files/NOT-OD-15-065.html </xsl:text>
                                                                    </fo:inline>
                                                                </fo:basic-link>
                                                                <fo:inline>
                                                                    <xsl:text>, except for the following:</xsl:text>
                                                                </fo:inline>
                                                                <fo:inline-container>
                                                                    <fo:block>
                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                    </fo:block>
                                                                </fo:inline-container>
                                                                <fo:list-block provisional-distance-between-starts="7mm"
                                                                               provisional-label-separation="2mm">
                                                                    <fo:list-item>
                                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                            <fo:block>
                                                                                <xsl:number format="a" value="1"/>.
                                                                            </fo:block>
                                                                        </fo:list-item-label>
                                                                        <fo:list-item-body start-indent="body-start()">
                                                                            <fo:block>
                                                                                <fo:inline>
                                                                                    <xsl:text>The right to initiate an automatic one-time extension of the end date provided by Article 25(c)(2) of the Research Terms and Conditions is replaced by the need to obtain prior written approval from the Pass-through Entity;</xsl:text>
                                                                                </fo:inline>
                                                                            </fo:block>
                                                                        </fo:list-item-body>
                                                                    </fo:list-item>
                                                                    <fo:list-item>
                                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                            <fo:block>
                                                                                <xsl:number format="a" value="2"/>.
                                                                            </fo:block>
                                                                        </fo:list-item-label>
                                                                        <fo:list-item-body start-indent="body-start()">
                                                                            <fo:block>
                                                                                <fo:inline>
                                                                                    <xsl:text>The payment mechanism described in Article 22 and the financial reporting requirements in Article 52 of the Research Terms and Conditions and Article 8 of the Agency-Specific Requirements are replaced with Terms and Conditions (1) through (4) of this Subaward Agreement; and</xsl:text>
                                                                                </fo:inline>
                                                                            </fo:block>
                                                                        </fo:list-item-body>
                                                                    </fo:list-item>
                                                                    <fo:list-item>
                                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                            <fo:block>
                                                                                <xsl:number format="a" value="3"/>.
                                                                            </fo:block>
                                                                        </fo:list-item-label>
                                                                        <fo:list-item-body start-indent="body-start()">
                                                                            <fo:block>
                                                                                <fo:inline>
                                                                                    <xsl:text>Any prior approvals are to be sought from the Pass-through Entity and not the Federal Awarding Agency.</xsl:text>
                                                                                </fo:inline>
                                                                            </fo:block>
                                                                        </fo:list-item-body>
                                                                    </fo:list-item>
                                                                </fo:list-block>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="5"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block>
                                                                <fo:inline>
                                                                    <xsl:text>Title to equipment costing $5,000 or more that is purchased or fabricated with research funds or Subrecipient cost sharing funds, as direct costs of the project or program, shall unconditionally vest in the Subrecipient upon acquisition without further obligation   to the Federal Awarding Agency subject to the conditions specified in Article 34(a) of the Research Terms and Conditions. </xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="6"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block>
                                                                <fo:inline>
                                                                    <xsl:text>Treatment of Program Income: </xsl:text>
                                                                </fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:TreatmentPrgmIncomeAdditive = &quot;Y&quot;">
                                                                        <fo:external-graphic content-height="8" content-width="8">
                                                                            <xsl:attribute name="src">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">
                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageCheckedPath,&apos;checked.gif&apos;))"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageCheckedPath,&apos;checked.gif&apos;)))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </fo:external-graphic>
                                                                    </xsl:when>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:TreatmentPrgmIncomeAdditive = &quot;N&quot;">
                                                                        <fo:external-graphic content-height="8" content-width="7">
                                                                            <xsl:attribute name="src">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">
                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;))"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;)))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </fo:external-graphic>
                                                                    </xsl:when>
                                                                </xsl:choose>
                                                                <fo:inline>
                                                                    <xsl:text> Additive  </xsl:text>
                                                                </fo:inline>
                                                                <fo:inline>
                                                                    <xsl:text>&#160;&#160;</xsl:text>
                                                                </fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:TreatmentPrgmIncomeAdditive = &quot;N&quot;">
                                                                        <fo:external-graphic content-height="8" content-width="8">
                                                                            <xsl:attribute name="src">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">
                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageCheckedPath,&apos;checked.gif&apos;))"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageCheckedPath,&apos;checked.gif&apos;)))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </fo:external-graphic>
                                                                    </xsl:when>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:TreatmentPrgmIncomeAdditive = &quot;Y&quot;">
                                                                        <fo:external-graphic content-height="8" content-width="7">
                                                                            <xsl:attribute name="src">
                                                                                <xsl:text>url(</xsl:text>
                                                                                <xsl:call-template name="double-backslash">
                                                                                    <xsl:with-param name="text">
                                                                                        <xsl:value-of
                                                                                                select="string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;))"/>
                                                                                    </xsl:with-param>
                                                                                    <xsl:with-param name="text-length">
                                                                                        <xsl:value-of
                                                                                                select="string-length(string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;)))"/>
                                                                                    </xsl:with-param>
                                                                                </xsl:call-template>
                                                                                <xsl:text>)</xsl:text>
                                                                            </xsl:attribute>
                                                                        </fo:external-graphic>
                                                                    </xsl:when>
                                                                </xsl:choose>
                                                                <fo:inline>
                                                                    <xsl:text> Other, Pass-through Entity specify alternative from NIH Agreement</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                </fo:list-block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>

                            <!--  insert conditional FCOI-PHS block -->
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <xsl:choose>
                                <xsl:when test="subcontract:SubContractData/subcontract:SubcontractDetail/subcontract:PHSFCOI = &quot;Y&quot;">
                                    <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                        <fo:table-body start-indent="0pt">
                                            <fo:table-row>
                                                <fo:table-cell padding="2pt" height="280pt" display-align="center">
                                                    <fo:block>
                                                        <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                                            <fo:table-column column-width="100%"/>
                                                            <fo:table-body start-indent="0pt">
                                                                <fo:table-row font-family="Times New Roman" font-size="10pt" font-weight="bold">
                                                                    <fo:table-cell padding="2pt">
                                                                        <fo:block>
                                                                            <fo:inline>
                                                                                <xsl:text>NIH-Specific Requirements Promoting Objectivity in Research Applicable to Subrecipients (42 CFR Part 50 Subpart F)</xsl:text>
                                                                            </fo:inline>
                                                                        </fo:block>
                                                                    </fo:table-cell>
                                                                </fo:table-row>
                                                            </fo:table-body>
                                                        </fo:table>
                                                        <fo:inline-container>
                                                            <fo:block>
                                                                <xsl:text>&#x2029;</xsl:text>
                                                            </fo:block>
                                                        </fo:inline-container>
                                                        <fo:table font-family="time" font-size="10pt" table-layout="fixed" width="100%"
                                                                  border-spacing="2pt">
                                                            <fo:table-column column-width="proportional-column-width(1)"/>
                                                            <fo:table-body start-indent="0pt">
                                                                <fo:table-row>
                                                                    <fo:table-cell padding="2pt" display-align="center">
                                                                        <fo:block>
                                                                            <fo:inline-container>
                                                                                <fo:block>
                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                </fo:block>
                                                                            </fo:inline-container>
                                                                            <fo:list-block provisional-distance-between-starts="7mm"
                                                                                           provisional-label-separation="2mm">
                                                                                <fo:list-item>
                                                                                    <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                                        <fo:block>
                                                                                        </fo:block>
                                                                                    </fo:list-item-label>
                                                                                    <fo:list-item-body start-indent="body-start()">
                                                                                        <fo:block font-family="time" font-size="10pt"
                                                                                                  font-weight="normal">
                                                                                            <fo:inline-container>
                                                                                                <fo:block>
                                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                                </fo:block>
                                                                                            </fo:inline-container>
                                                                                            <fo:list-block provisional-distance-between-starts="7mm"
                                                                                                           provisional-label-separation="2mm">
                                                                                                <fo:list-item>
                                                                                                    <fo:list-item-label end-indent="label-end()"
                                                                                                                        text-align="right">
                                                                                                        <fo:block>
                                                                                                            <xsl:number format="a" value="1"/>.
                                                                                                        </fo:block>
                                                                                                    </fo:list-item-label>
                                                                                                    <fo:list-item-body start-indent="body-start()">
                                                                                                        <fo:block>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>42 CFR Part 50. 604 requires that institutions conducting PHS-funded research "Maintain an up-to-date, written, enforced policy on</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>financial conflicts of interest." Further, "If the Institution carries out the PHS-funded research through a subrecipient (e.g., subcontractors or consortium members), the Institution (awardee Institution) must take reasonable steps to ensure that any subrecipient Investigator complies with this subpart by incorporating as part of a written agreement with the subrecipient terms that establish whether the financial conflicts of interest policy of the awardee Institution or that of the subrecipient will apply to the subrecipient Investigators."</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <fo:block white-space-collapse="false"
                                                                                                                      white-space-treatment="preserve"
                                                                                                                      font-size="0pt"
                                                                                                                      line-height="15px"></fo:block>
                                                                                                            <fo:block>
                                                                                                                <xsl:text>&#x00A0;</xsl:text>
                                                                                                            </fo:block>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>Subrecipient must designate herein whether the financial conflicts of interest policy of</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <fo:inline>
                                                                                                                <fo:external-graphic content-height="8"
                                                                                                                                     content-width="7">
                                                                                                                    <xsl:attribute name="src">
                                                                                                                        <xsl:text>url(</xsl:text>
                                                                                                                        <xsl:call-template
                                                                                                                                name="double-backslash">
                                                                                                                            <xsl:with-param name="text">
                                                                                                                                <xsl:value-of
                                                                                                                                        select="string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;))"/>
                                                                                                                            </xsl:with-param>
                                                                                                                            <xsl:with-param
                                                                                                                                    name="text-length">
                                                                                                                                <xsl:value-of
                                                                                                                                        select="string-length(string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;)))"/>
                                                                                                                            </xsl:with-param>
                                                                                                                        </xsl:call-template>
                                                                                                                        <xsl:text>)</xsl:text>
                                                                                                                    </xsl:attribute>
                                                                                                                </fo:external-graphic>
                                                                                                            </fo:inline>
                                                                                                            <xsl:text></xsl:text>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>Prime Recipient Institution, or</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <fo:inline>
                                                                                                                <fo:external-graphic content-height="8"
                                                                                                                                     content-width="7">
                                                                                                                    <xsl:attribute name="src">
                                                                                                                        <xsl:text>url(</xsl:text>
                                                                                                                        <xsl:call-template
                                                                                                                                name="double-backslash">
                                                                                                                            <xsl:with-param name="text">
                                                                                                                                <xsl:value-of
                                                                                                                                        select="string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;))"/>
                                                                                                                            </xsl:with-param>
                                                                                                                            <xsl:with-param
                                                                                                                                    name="text-length">
                                                                                                                                <xsl:value-of
                                                                                                                                        select="string-length(string(concat(subcontract:SubContractData/subcontract:PrintRequirement/subcontract:ImageUncheckedPath,&apos;checkbox.gif&apos;)))"/>
                                                                                                                            </xsl:with-param>
                                                                                                                        </xsl:call-template>
                                                                                                                        <xsl:text>)</xsl:text>
                                                                                                                    </xsl:attribute>
                                                                                                                </fo:external-graphic>
                                                                                                            </fo:inline>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text></xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>Subrecipient Institution (check one) will apply. If applying its own financial conflicts of interest policy, by execution of this Subaward Agreement, Subrecipient Institution certifies that its policy complies with 42 CFR Part 50.</xsl:text>
                                                                                                            </fo:inline>
                                                                                                        </fo:block>
                                                                                                        <fo:block>
                                                                                                            <xsl:text>&#x00A0;</xsl:text>
                                                                                                        </fo:block>
                                                                                                        <fo:block white-space-collapse="false"
                                                                                                                  white-space-treatment="preserve"
                                                                                                                  font-size="0pt"
                                                                                                                  line-height="15px"></fo:block>
                                                                                                    </fo:list-item-body>
                                                                                                </fo:list-item>
                                                                                                <fo:list-item>
                                                                                                    <fo:list-item-label end-indent="label-end()"
                                                                                                                        text-align="right">
                                                                                                        <fo:block>
                                                                                                            <xsl:number format="a" value="2"/>.
                                                                                                        </fo:block>
                                                                                                    </fo:list-item-label>
                                                                                                    <fo:list-item-body start-indent="body-start()">
                                                                                                        <fo:block>
                                                                                                            <fo:inline>
                                                                                                                <xsl:text>Subrecipient shall report any financial conflict of interest to Prime Recipients Administrative Representative, as designated on Attachment 3A. Any financial conflicts of interest identified shall subsequently be reported to NIH.</xsl:text>
                                                                                                            </fo:inline>
                                                                                                            <fo:inline font-size="10pt"
                                                                                                                       text-decoration="underline">
                                                                                                                <xsl:text>Such report shall be made before expenditure of funds authorized in this Subrecipient Agreement and within 45 days of any subsequently identified financial conflict of interest.</xsl:text>
                                                                                                            </fo:inline>
                                                                                                        </fo:block>
                                                                                                    </fo:list-item-body>
                                                                                                </fo:list-item>
                                                                                            </fo:list-block>
                                                                                        </fo:block>
                                                                                    </fo:list-item-body>
                                                                                </fo:list-item>
                                                                            </fo:list-block>
                                                                        </fo:block>
                                                                    </fo:table-cell>
                                                                </fo:table-row>
                                                            </fo:table-body>
                                                        </fo:table>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                </xsl:when>
                                <xsl:otherwise>
                                    <fo:inline-container>
                                        <fo:block>
                                            <xsl:text>&#x2029;</xsl:text>
                                        </fo:block>
                                    </fo:inline-container>
                                </xsl:otherwise>
                            </xsl:choose>
                            <!--  end of conditional FCOI-PHS block -->




                            <fo:table font-family="time" table-layout="fixed" width="100%" border-spacing="2pt">
                                <fo:table-column column-width="28%"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell font-family="times" font-size="12pt" font-weight="bold" padding="2pt" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>Special terms and conditions:</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                        <fo:table-cell font-family="time" font-size="10pt" padding="2pt" display-align="center">
                                            <fo:block>
                                                <fo:inline>
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                    <fo:table-row font-family="time" font-size="10pt">
                                        <fo:table-cell font-family="times" font-size="12pt" font-weight="bold" number-columns-spanned="2" padding="2pt"
                                                       display-align="center">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:list-block font-family="time" font-size="10pt" font-weight="normal"
                                                               provisional-distance-between-starts="7mm" provisional-label-separation="2mm">
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="1"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block>
                                                                <fo:inline>
                                                                    <xsl:text>Copyrights</xsl:text>
                                                                </fo:inline>
                                                                <fo:block/>
                                                                <fo:inline>
                                                                    <xsl:text>Subrecipient</xsl:text>
                                                                </fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:CopyRights = &quot;1&quot;">
                                                                        <fo:inline>
                                                                            <xsl:text> grants</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:CopyRights = &quot;2&quot;">
                                                                        <fo:inline>
                                                                            <xsl:text> shall grant</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:when>
                                                                </xsl:choose>
                                                                <fo:inline>
                                                                    <xsl:text> to Prime Recipient an irrevocable, royalty-free, non-transferable, non-exclusive right and license to use, reproduce, make derivative works, display, and perform publicly any copyrights or copyrighted material (including any computer software and its documentation and/or databases) first developed and delivered under this Subaward Agreement solely for the purpose of and only to the extent required to meet Prime Recipient''s obligations to the Federal Government under its Prime Award.</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="2"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block>
                                                                <fo:inline>
                                                                    <xsl:text>Data Rights</xsl:text>
                                                                </fo:inline>
                                                                <fo:block/>
                                                                <fo:inline>
                                                                    <xsl:text>Subrecipient</xsl:text>
                                                                </fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:CopyRights = &quot;1&quot;">
                                                                        <fo:inline>
                                                                            <xsl:text> grants</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:CopyRights = &quot;2&quot;">
                                                                        <fo:inline>
                                                                            <xsl:text> shall grant</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:when>
                                                                </xsl:choose>
                                                                <fo:inline>
                                                                    <xsl:text> to Prime Recipient the right to use data created in the performance of this Subaward Agreement solely for the purpose of and only to the extent required to meet Prime Recipient''s obligations to the Federal Government under its Prime Award.</xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="3"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block>
                                                                <fo:inline>
                                                                    <xsl:text>Automatic Carry Forward:&#160; </xsl:text>
                                                                </fo:inline>
                                                                <xsl:choose>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:AutomaticCarryForward = &apos;Y&apos;">
                                                                        <fo:inline>
                                                                            <xsl:text>Yes</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:when>
                                                                    <xsl:when
                                                                            test="subcontract:SubContractData/subcontract:SubcontractTemplateInfo/subcontract:AutomaticCarryForward = &apos;N&apos;">
                                                                        <fo:inline>
                                                                            <xsl:text>No</xsl:text>
                                                                        </fo:inline>
                                                                        <fo:block/>
                                                                        <fo:inline>
                                                                            <xsl:text>Carry Forward requests must be sent to </xsl:text>
                                                                        </fo:inline>
                                                                        <xsl:for-each select="subcontract:SubContractData">
                                                                            <xsl:for-each select="subcontract:SubcontractTemplateInfo">
                                                                                <xsl:for-each select="subcontract:CarryForwardRequestsSentToDescription">
                                                                                    <xsl:variable name="value-of-template">
                                                                                        <xsl:apply-templates/>
                                                                                    </xsl:variable>
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                            <fo:block>
                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                            </fo:block>
                                                                                        </xsl:when>
                                                                                        <xsl:otherwise>
                                                                                            <fo:inline>
                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                            </fo:inline>
                                                                                        </xsl:otherwise>
                                                                                    </xsl:choose>
                                                                                </xsl:for-each>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                        <fo:inline>
                                                                            <xsl:text>, as shown in Attachment 3.</xsl:text>
                                                                        </fo:inline>
                                                                    </xsl:when>
                                                                </xsl:choose>
                                                                <fo:inline>
                                                                    <xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
                                                                </fo:inline>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>
                                                    <fo:list-item>
                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                            <fo:block>
                                                                <xsl:number format="1" value="4"/>.
                                                            </fo:block>
                                                        </fo:list-item-label>
                                                        <fo:list-item-body start-indent="body-start()">
                                                            <fo:block font-family="time" font-size="10pt" font-weight="normal">
                                                                <fo:inline>
                                                                    <xsl:text>In accordance with 48 CFR 3.908 Pilot Program for Enhancement of Contractor Employee Protections. Subrecipient is hereby notified that they are required to: </xsl:text>
                                                                </fo:inline>
                                                                <fo:inline-container>
                                                                    <fo:block>
                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                    </fo:block>
                                                                </fo:inline-container>
                                                                <fo:list-block provisional-distance-between-starts="7mm"
                                                                               provisional-label-separation="2mm">
                                                                    <fo:list-item>
                                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                            <fo:block>
                                                                                <xsl:number format="a" value="1"/>.
                                                                            </fo:block>
                                                                        </fo:list-item-label>
                                                                        <fo:list-item-body start-indent="body-start()">
                                                                            <fo:block>
                                                                                <fo:inline>
                                                                                    <xsl:text>Inform their employees working on any Federal award that they are subject to the whistleblower rights and remedies of the pilot program;</xsl:text>
                                                                                </fo:inline>
                                                                            </fo:block>
                                                                        </fo:list-item-body>
                                                                    </fo:list-item>
                                                                    <fo:list-item>
                                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                            <fo:block>
                                                                                <xsl:number format="a" value="2"/>.
                                                                            </fo:block>
                                                                        </fo:list-item-label>
                                                                        <fo:list-item-body start-indent="body-start()">
                                                                            <fo:block>
                                                                                <fo:inline>
                                                                                    <xsl:text>Inform their employees in writing of employee whistleblower protections under 41 U.S.C §4712 in the predominant native language of the workforce; and; </xsl:text>
                                                                                </fo:inline>
                                                                            </fo:block>
                                                                        </fo:list-item-body>
                                                                    </fo:list-item>
                                                                    <fo:list-item>
                                                                        <fo:list-item-label end-indent="label-end()" text-align="right">
                                                                            <fo:block>
                                                                                <xsl:number format="a" value="3"/>.
                                                                            </fo:block>
                                                                        </fo:list-item-label>
                                                                        <fo:list-item-body start-indent="body-start()">
                                                                            <fo:block>
                                                                                <fo:inline>
                                                                                    <xsl:text>Contractors and grantees will include such requirements in any agreement made with a subcontractor or subgrantee</xsl:text>
                                                                                </fo:inline>
                                                                            </fo:block>
                                                                        </fo:list-item-body>
                                                                    </fo:list-item>
                                                                </fo:list-block>
                                                            </fo:block>
                                                        </fo:list-item-body>
                                                    </fo:list-item>









                                                </fo:list-block>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>






                            <fo:block/>
                            <fo:block/>
                        </xsl:for-each>
                        <fo:block/>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="headerall">
        <fo:static-content flow-name="xsl-region-before">
            <fo:block>
                <xsl:for-each select="$XML"/>
            </fo:block>
        </fo:static-content>
    </xsl:template>
<xsl:template name="double-backslash">
<xsl:param name="text"/>
<xsl:param name="text-length"/>
<xsl:variable name="text-after-bs" select="substring-after($text, ''\\'')"/>
<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
<xsl:choose>
<xsl:when test="$text-after-bs-length = 0">
<xsl:choose>
<xsl:when test="substring($text, $text-length) = ''\\''">
<xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="$text"/>
</xsl:otherwise>
</xsl:choose>
</xsl:when>
<xsl:otherwise>
<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
<xsl:call-template name="double-backslash">
<xsl:with-param name="text" select="$text-after-bs"/>
<xsl:with-param name="text-length" select="$text-after-bs-length"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
</xsl:stylesheet>

','NIH Attachment.xsl','application/octet-stream',1,UUID(),2);
